% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_smoothed_data.R
\name{regress_data}
\alias{regress_data}
\title{Regress one pupil against another for extra smoothing}
\usage{
regress_data(data, pupil1, pupil2)
}
\arguments{
\item{data}{a PupillometryR dataframe}

\item{pupil1}{Column name for first pupil data}

\item{pupil2}{Column name for second pupil data}
}
\value{
a PupillometryR dataframe with smoothed pupil values
}
\description{
regress_data runs a simple linear regression of pupil1 against pupil2 and the reverse.
This can help to account for small amount of bumpiness in the data.
The regression runs over each participant and each trial, per time.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
subject = ID,
trial = Trial,
time = Time,
condition = Type)
regressed_data <- regress_data(data = Sdata,
pupil1 = RPupil,
pupil2 = LPupil)
mean_data <- calculate_mean_pupil_size(data = regressed_data,
pupil1 = RPupil, pupil2 = LPupil)

}
