% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{recode_off_screen}
\alias{recode_off_screen}
\title{Check for samples off-screen and marks as NA.}
\usage{
recode_off_screen(data = data, ScreenSize = NULL, PlotData = FALSE)
}
\arguments{
\item{data}{A data frame object created from an Eyelink Sample Report.}

\item{ScreenSize}{A numeric vector specifying (in pixels) the dimensions
of the x and y of the screen used during the experiment.}

\item{PlotData}{A logical indicating whether or not to output a
visualization of the result.}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{recode_off_screen} checks samples falling outside the bounds of
the screen and marks them with NA
}
\examples{
# Load example data
data("Pupilex3")

dat <- recode_off_screen(data = Pupilex3, ScreenSize = c(1920, 1080),
                         PlotData = FALSE)

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Basic_Preprocessing", package="PupilPre")

}
