% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PsychWordVec.R
\name{test_WEAT}
\alias{test_WEAT}
\title{Word Embedding Association Test (WEAT) and Single-Category WEAT.}
\usage{
test_WEAT(data, T1, T2, A1, A2, use.pattern = FALSE, labels)
}
\arguments{
\item{data}{A \code{data.table} (of new class \code{wordvec})
loaded by \code{\link{data_wordvec_load}}.}

\item{T1, T2}{Target words (a vector of words or a pattern of regular expression).
If only \code{T1} is specified,
it will tabulate data for single-category WEAT (SC-WEAT).}

\item{A1, A2}{Attribute words (a vector of words or a pattern of regular expression).
Both must be specified.}

\item{use.pattern}{Defaults to \code{FALSE} (using a vector of words).
If you use regular expression in \code{T1}, \code{T2}, \code{A1}, and \code{A2},
please specify this argument as \code{TRUE}.}

\item{labels}{Labels for target and attribute concepts (a named \code{list}),
such as (the default)
\code{list(T1="Target1", T2="Target2", A1="Attrib1", A2="Attrib2")}.}
}
\value{
A \code{list} of objects:
\describe{
  \item{\code{words.valid}}{
    valid (actually matched) words}
  \item{\code{data.raw}}{
    \code{data.table} of cosine similarities between all word pairs}
  \item{\code{data.mean}}{
    \code{data.table} of \emph{mean} cosine similarities
    \emph{across} all attribute words}
  \item{\code{data.diff}}{
    \code{data.table} of \emph{differential} mean cosine similarities
    \emph{between} the two attribute concepts}
  \item{\code{code.diff}}{
    description for the difference between the two attribute concepts}
  \item{\code{eff.type}}{
    effect type: WEAT or SC-WEAT}
  \item{\code{eff.raw}}{
    raw effect for WEAT (a single value) or SC-WEAT (a data table)}
  \item{\code{eff.size}}{
    standardized effect size for WEAT (a single value) or SC-WEAT (a data table)}
}
}
\description{
Tabulate data (cosine similarity and standardized effect size) for the
\emph{Word Embedding Association Test} (WEAT) and
\emph{Single-Category Word Embedding Association Test} (SC-WEAT) analyses.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
## Remember: cc() is more convenient than c()!

weat = test_WEAT(
  demodata,
  T1=cc("king, King"),
  T2=cc("queen, Queen"),
  A1=cc("male, man, boy, brother, he, him, his, son"),
  A2=cc("female, woman, girl, sister, she, her, hers, daughter"),
  labels=list(T1="King", T2="Queen", A1="Male", A2="Female"))
weat

weat = test_WEAT(
  demodata,
  T1="^[kK]ing$",
  T2="^[qQ]ueen$",
  A1="^male$|^man$|^boy$|^brother$|^he$|^him$|^his$|^son$",
  A2="^female$|^woman$|^girl$|^sister$|^she$|^her$|^hers$|^daughter$",
  use.pattern=TRUE,
  labels=list(T1="King", T2="Queen", A1="Male", A2="Female"))
weat

sc_weat = test_WEAT(
  demodata,
  T1=cc("
    architect, boss, leader, engineer, CEO, officer, manager,
    lawyer, scientist, doctor, psychologist, investigator,
    consultant, programmer, teacher, clerk, counselor,
    salesperson, therapist, psychotherapist, nurse"),
  A1=cc("male, man, boy, brother, he, him, his, son"),
  A2=cc("female, woman, girl, sister, she, her, hers, daughter"),
  labels=list(T1="Occupation", A1="Male", A2="Female"))
sc_weat

}
\references{
Caliskan, A., Bryson, J. J., & Narayanan, A. (2017).
Semantics derived automatically from language corpora contain human-like biases.
\emph{Science, 356}(6334), 183--186.
}
\seealso{
\code{\link{tab_similarity}}

\code{\link{test_RND}}
}
