% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PsychWordVec.R
\name{get_wordvec}
\alias{get_wordvec}
\title{Extract the word vector of a single word.}
\usage{
get_wordvec(data, word)
}
\arguments{
\item{data}{A \code{data.table} (of new class \code{wordvec})
loaded by \code{\link{data_wordvec_load}}.}

\item{word}{Word string (a single word).}
}
\value{
A numeric vector of the word
(or \code{NA} if the word does not appear in the data).
}
\description{
Extract the word vector of a single word.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
d = data_wordvec_normalize(demodata)

v1 = get_wordvec(demodata, "China")  # raw vector
v2 = get_wordvec(d, "China")  # normalized vector
cor(v1, v2)
cosine_similarity(v1, v2)

}
\seealso{
\code{\link{get_wordvecs}}

\code{\link{plot_wordvec}}

\code{\link{plot_wordvec_tSNE}}
}
