% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procmod_frame.R
\name{subset.procmod_frame}
\alias{subset.procmod_frame}
\title{Subsetting Procmod Frames}
\usage{
\method{subset}{procmod_frame}(x, subset, select, drop = FALSE, ...)
}
\arguments{
\item{x}{object to be subsetted.}

\item{subset}{logical expression indicating elements or
rows to keep: missing values are taken as false.}

\item{select}{expression, indicating columns to select from a data frame.}

\item{drop}{passed on to [ indexing operator.}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
A \code{procmod_frame} containing just the selected rows and columns.
}
\description{
This is the implementation of the \code{\link[base]{subset}} generic function for
\code{procmod_frame}.
}
\details{
The subset argument works on rows. Note that subset will be evaluated in the
\code{procmod_frame}, so columns can be referred to (by name) as variables
in the expression (see the examples).

The select argument if provided indicates with matrices
have to be conserved.  It works by first replacing column names in the selection
expression with the corresponding column numbers in the \code{procmod_frame} and then using
the resulting integer vector to index the columns. This allows the use of the
standard indexing conventions so that for example ranges of columns can
be specified easily, or single columns can be dropped (see the examples). Remember
that each column of a \code{procmod_frame} is actually a matrix.

The drop argument is passed on to the \code{procmod_frame} indexing method.
The default value is \code{FALSE}.
}
\examples{
library(vegan)
data(bacteria)
data(eukaryotes)
data(soil)

dataset <- procmod_frame(euk = vegdist(decostand(eukaryotes,
                                                 method = "hellinger"),
                                       method = "euclidean"),
                         bac = vegdist(decostand(bacteria,
                                                 method = "hellinger"),
                                       method = "euclidean"),
                         soil = scale(soil,
                                      center = TRUE,
                                      scale  = TRUE))
dim(dataset)

higher_ph = subset(dataset,soil[,"pH"] > 0)
dim(higher_ph)

without_bacteria = subset(dataset,soil[,"pH"] > 0, -bac)
dim(without_bacteria)

}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
