% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_upcoming_bills.R
\name{get_upcoming_bills}
\alias{get_upcoming_bills}
\title{Get Upcoming Bills}
\usage{
get_upcoming_bills(chamber, page = 1, myAPI_Key)
}
\arguments{
\item{chamber}{house or senate.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves details on bills that may be considered by the House or Senate in the near future, based on scheduled published or announced by congressional leadership.
}
\description{
The responses include a legislative_day attribute which is the earliest the bills could be considered and a range attribute that indicates whether the bill information comes from a weekly schedule or a daily one. Combine the two for the best sense of when a bill might come up for consideration. For Senate bills, the response includes a context attribute reproducing the sentence that includes mention of the bill. These responses omit bills that have not yet been assigned a bill number or introduced, and additional bills may be considered at any time. HTTP Request: GET https://api.propublica.org/congress/v1/bills/upcoming/{chamber}.json
}
\examples{
\donttest{
get_upcoming_bills('senate')
}
}
