% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_recent_personal_explanations.R
\name{get_recent_personal_explanations}
\alias{get_recent_personal_explanations}
\title{Get Recent Personal Explanations}
\usage{
get_recent_personal_explanations(congress, page = 1, myAPI_Key)
}
\arguments{
\item{congress}{101-116}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent results in the specified Congress
}
\description{
Lawmakers, mostly in the House but also in the Senate, can make personal explanations for missed or mistaken votes in the Congressional Record. These explanations can refer to a single vote or to multiple votes. To get lists of personal explanations, use the following URI structure. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/explanations.json
}
\examples{
\donttest{
get_recent_personal_explanations(114)
}
}
