% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_recent_official_communications.R
\name{get_recent_official_communications}
\alias{get_recent_official_communications}
\title{Get Recent Official Communications}
\usage{
get_recent_official_communications(congress, myAPI_Key)
}
\arguments{
\item{congress}{114-115 for House, 96-115 for Senate}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent official communications to Congress from the president, executive branch agencies and state legislatures to congressional committees. The data covers communications to the House of Representatives since 2015, and communications to the Senate since 1979.
}
\description{
To get lists of official communications to Congress from the president, executive branch agencies and state legislatures to congressional committees, use the following function. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/communications.json
}
\examples{
\donttest{
get_recent_official_communications(115)
}
}
