% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxTables.R
\name{toxTables}
\alias{toxTables}
\title{Create toxicity tables for individual and composite PRO-CTCAE survey items.}
\usage{
toxTables(
  dsn,
  id_var,
  cycle_var,
  baseline_val,
  type = "bl_adjusted",
  test = "c",
  riskdiff = FALSE,
  risk_ci = "wald",
  risk_ci_alpha = 0.05,
  arm_var = NA,
  cycle_limit = NA
)
}
\arguments{
\item{dsn}{A data.frame object with PRO-CTCAE data.}

\item{id_var}{A character string. Name of ID variable differentiating each
PRO-CTCAE survey/participant entered as a quoted string.}

\item{cycle_var}{A character string. Name of variable differentiating one
longitudinal/repeated. PRO-CTCAE survey from another, within an individual
ID.}

\item{baseline_val}{A number indicating the expected baseline cycle/time
point.}

\item{type}{A character string. Type of summary measure to be be used.
Options include: \code{"max_post_bl"} = Use subjects' maximum score
post-baseline visit. \code{"bl_adjusted"} = Use subjects' baseline adjusted
score over the study period. \code{"max"} = Use subjects' maximum score
over the study period. The baseline adjusted score is derived by the
following: If the maximum score post-baseline is more severe than the
baseline score, then the use maximum score post-baseline is used as the
adjusted score. Otherwise, if the maximum score post-baseline is the same
or less serve than the baseline score, then zero (0) is used as the
adjusted score. Defaults to \code{"bl_adjusted"}.}

\item{test}{A character string. Specify the statistical test to apply where
comparing rates among arms. Options include: \code{"c"} = chi square,
\code{"f"} = fisher's exact. Defaults to \code{"c"}.}

\item{riskdiff}{Logical. Calculates risk differences between two arms. Valid
if there are only two arms in the data.frame specified. This option will
countermand options called with the \code{test} parameter. Defaults to
\code{FALSE}.}

\item{risk_ci}{A character string. Specify the confidence interval type
to be constructed for risk differences. Options include: \code{"wald"},
and \code{"agresti-caffo"}. Defaults to \code{"wald"}.}

\item{risk_ci_alpha}{A number between 0 and 1. Specify the alpha level of
the risk difference confidence intervals. Defaults to \code{0.05}.}

\item{arm_var}{A character string. Name of arm variable differentiating
treatment groups. Must be character or factor class. Overall frequencies
will be reported if no arm/grouping variable is provided. Defaults to
\code{NA}.}

\item{cycle_limit}{A number. Limit the data to be analyzed up to and
including a given cycle number or time point. Defaults to \code{NA}.}
}
\value{
A list object with data.frame elements for individual items and
  composite grades.
}
\description{
Data format should be in 'long' format, where each PRO-CTCAE item is a
	  variable/column.
}
\examples{
toxTables(dsn=ProAE::tox_acute, id_var="id", cycle_var="Cycle", baseline_val=1)
}
