% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{variog.diagnostic.lm}
\alias{variog.diagnostic.lm}
\title{Variogram-based validation for linear geostatistical model fits}
\usage{
variog.diagnostic.lm(
  object,
  n.sim = 1000,
  uvec = NULL,
  plot.results = TRUE,
  range.fact = 1,
  which.test = "both",
  param.uncertainty = FALSE
)
}
\arguments{
\item{object}{an object of class "PrevMap" obtained as an output from \code{\link{linear.model.MLE}}.}

\item{n.sim}{integer indicating the number of simulations used for the variogram-based diagnostics.
Defeault is \code{n.sim=1000}.}

\item{uvec}{a vector with values used to define the variogram binning. If \code{uvec=NULL}, then \code{uvec} is then set to \code{seq(MIN_DIST,(MAX_DIST-MIN_DIST)/2,length=15)}}

\item{plot.results}{if \code{plot.results=TRUE}, a plot is returned showing the results for the selected test(s) for spatial correlation. By default \code{plot.results=TRUE}.}

\item{range.fact}{a value between 0 and 1 used to disregard all distance bins provided through \code{uvec} that are larger than the (pr)x\code{range.fact}, where pr is the practical range,
defined as the distance at which the fitted spatial correlation is no less than 0.05. Default is \code{range.fact=1}}

\item{which.test}{a character specifying which test for residual spatial correlation is to be performed: "variogram", "test statistic" or "both". The default is \code{which.test="both"}. See 'Details.'}

\item{param.uncertainty}{a logical indicating whether uncertainty in the model parameters should be incorporated in the selected diagnostic tests. Default is \code{param.uncertainty=FALSE}. See 'Details.'}
}
\value{
An object of class "PrevMap.diagnostic" which is a list containing the following components:

\code{obs.variogram}: a vector of length \code{length(uvec)-1} containing the values of the variogram for each of
the distance bins defined through \code{uvec}.

\code{distance.bins}: a vector of length \code{length(uvec)-1} containing the average distance within each of the distance bins
defined through \code{uvec}.

\code{n.bins}: a vector of length \code{length(uvec)-1} containing the number of pairs of data-points falling within each distance bin.

\code{lower.lim}: (available only if \code{which.test="both"} or \code{which.test="variogram"}) a vector of length \code{length(uvec)-1} containing the lower limits of the 95% confidence interval for the empirical variogram
generated under the assumption of absence of suitability of the fitted model  at each fo the distance bins  defined through \code{uvec}.

\code{upper.lim}: (available only if \code{which.test="both"} or \code{which.test="variogram"}) a vector of length \code{length(uvec)-1} containing the upper limits of the 95% confidence interval for the empirical variogram
generated under the assumption of absence of suitability of the fitted model at each fo the distance bins  defined through \code{uvec}.

\code{mode.rand.effects}: the predictive mode of the random effects from the fitted non-spatial generalized linear mixed model.

\code{p.value}: (available only if \code{which.test="both"} or \code{which.test="test statistic"}) p-value of the test for residual spatial correlation.

\code{lse.variogram}: (available only if \code{lse.variogram=TRUE}) a vector of length \code{length(uvec)-1} containing the values of the estimated Matern variogram via a weighted least square fit.
}
\description{
This function performs model validation for linear geostatistical model
using Monte Carlo methods based on the variogram.
}
\details{
The function takes as an input through the argument \code{object} a fitted
linear geostaistical model for an outcome \eqn{Y_i}, which is expressed as
\deqn{Y_i=d_i'\beta+S(x_i)+Z_i}
where \eqn{d_i} is a vector of covariates which are specified through \code{formula}, \eqn{S(x_i)} is a spatial Gaussian process and the \eqn{Z_i} are assumed to be zero-mean Gaussian.
The model validation is performed on the adopted satationary and isotropic Matern covariance function used for \eqn{S(x_i)}.
More specifically, the function allows the users to select either of the following validation procedures.

\bold{Variogram-based graphical validation}

This graphical diagnostic is performed by setting \code{which.test="both"} or \code{which.test="variogram"}. The output are 95% confidence intervals
(see below \code{lower.lim} and \code{upper.lim}) that are generated under the assumption that the fitted model did generate the analysed data-set.
This validation procedure proceed through the following steps.

1. Obtain the mean, say \eqn{\hat{Z}_i}, of the \eqn{Z_i} conditioned on the data \eqn{Y_i}.

2. Compute the empirical variogram using \eqn{\hat{Z}_i}

3. Simulate \code{n.sim} data-sets under the fitted geostatistical model.

4. For each of the simulated data-sets and obtain \eqn{\hat{Z}_i} as in Step 1.
Finally, compute the empirical variogram based on the resulting \eqn{\hat{Z}_i}.

5. From the \code{n.sim} variograms obtained in the previous step, compute the 95% confidence interval.

If the observed variogram (\code{obs.variogram} below), based on the \eqn{\hat{Z}_i} from Step 2, falls within the 95% confidence interval, we interpret this as evidence that the data do not show
evidence against the fitted spatial correlation model; if, instead, that partly falls outside the 95% confidence intervals, we interpret this as evidence that the fitted model does not adequately capture the residual spatial
correlation in the data.

\bold{Test for suitability of the adopted correlation function}

This diagnostic test is performed if \code{which.test="both"} or \code{which.test="test statistic"}. Let \eqn{v_{E}(B)} and \eqn{v_{T}(B)} denote the empirical and theoretical variograms based on \eqn{\hat{Z}_i} for the distance bin \eqn{B}.
The test statistic used for testing residual spatial correlation is
\deqn{T = \sum_{B} N(B) \{v_{E}(B)-v_{T}(B)\}}
where \eqn{N(B)} is the number of pairs of data-points falling within the distance bin \eqn{B} (\code{n.bins} below).

To obtain the distribution of the test statistic \eqn{T} under the null hypothesis that the fitted model did generate the analysed data-set, we use the simulated empirical variograms as obtained in step 5 of the iterative procedure described in "Variogram-based graphical validation."
The p-value for the test of suitability of the fitted spatial correlation function is then computed by taking the proportion of simulated values for \eqn{T} that are larger than the value of \eqn{T} based on the original \eqn{\hat{Z}_i} in Step 1.
}
