% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Accuracy.R
\name{Accuracy}
\alias{Accuracy}
\title{Verify how well NASA-POWER Data Represent Observed Data}
\usage{
Accuracy(obs_est, conf.int = "Yes", sig.level = 0.95)
}
\arguments{
\item{obs_est}{A 2-column matrix. The reference or observed and the estimated or predicted
data. See \code{ObsEst} object as an example.}

\item{conf.int}{A character variable (\code{Yes} or \code{No}) defining if the function must
calculate confidence intervals.  Default is \dQuote{Yes}.}

\item{sig.level}{A numeric variable (between 0.90 and 0.95) defining the significance level
for parameter the confidence intervals.  Default is 0.95.}
}
\value{
An object of class \code{PowerSDI.Accuracy}, a \code{list}, which contains:

\itemize{
 \item Absolute mean error (AME),
 \item square root of the mean squared error (RMSE),
 \item Willmott's indices of agreement:
   \itemize{
     \item original (dorig),
     \item modified (dmod) and
     \item refined (dref)
     }
 \item Pearson determination coefficient (R2), and
 \item if \code{conf.int = "Yes"}, confidence intervals.
 }
}
\description{
Calculates scalar measures of accuracy.
}
\examples{
a <- Accuracy(obs_est = ObsEst, conf.int = "No")
a

# A generic plotting method is also supplied
plot(a)

}
