% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{weight_by_risk_parity}
\alias{weight_by_risk_parity}
\title{Risk Parity Weighting Suite}
\usage{
weight_by_risk_parity(
  selected_df,
  prices_df,
  method = c("inverse_vol", "equal_risk", "max_div"),
  lookback_periods = 252,
  min_periods = 60
)
}
\arguments{
\item{selected_df}{Binary selection matrix (data.frame with Date column).}

\item{prices_df}{Price data for risk calculations (typically daily).
Returns are calculated internally from prices.}

\item{method}{Optimization method for risk parity.}

\item{lookback_periods}{Number of periods for risk estimation (default: 252).}

\item{min_periods}{Minimum periods required (default: 60).}
}
\value{
Weight matrix with the same dates as \code{selected_df}; each row sums to 1.
}
\description{
Collection of risk-based weighting methods for portfolio construction.
Each method allocates capital based on risk characteristics rather than
market capitalization or equal weights.
}
\details{
\strong{Methods}
\describe{
\item{\code{inverse_vol}}{Weights proportional to 1 / volatility
(e.g., 1 / sd of returns over \code{lookback_periods}). Lower volatility
stocks receive higher weights.}
\item{\code{equal_risk}}{Equal Risk Contribution (ERC): finds weights so
each position contributes equally to total portfolio risk (iterative optimization).}
\item{\code{max_div}}{Maximum Diversification: maximizes the ratio of
weighted average volatility to portfolio volatility.}
}

The function accepts price data and calculates returns internally,
ensuring consistency with other library functions. Daily prices are
recommended for accurate volatility estimation.
}
\examples{
data("sample_prices_daily")
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, n = 10)
weight_by_risk_parity(selected, sample_prices_daily, method = "inverse_vol")
weight_by_risk_parity(selected, sample_prices_daily, method = "equal_risk")
weight_by_risk_parity(selected, sample_prices_daily, method = "max_div")
}
