/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ByteUtil {
    public static final byte[] EMPTY = new byte[0];

    public static byte[] convertBitStringToFastByteArray(String bitString) {
        if (bitString.length() == 0) {
            return new byte[0];
        }
        String[] bitStrings = bitString.split(" ");
        byte[] bytes = new byte[bitStrings.length];
        int i = 0;
        while (i < bitStrings.length) {
            bytes[i] = (byte)Integer.parseInt(bitStrings[i], 2);
            ++i;
        }
        return bytes;
    }

    public static byte[] convertHexStringToByteArray(String hexString) {
        if (hexString == null) {
            return new byte[0];
        }
        hexString = hexString.replaceAll(" ", "");
        byte[] bytes = new byte[hexString.length() / 2];
        int i = 0;
        while (i < hexString.length()) {
            bytes[i / 2] = (byte)Integer.parseInt(hexString.substring(i, i + 2), 16);
            i += 2;
        }
        return bytes;
    }

    public static String convertByteArrayToHexString(byte[] value) {
        StringBuffer builder = new StringBuffer(value.length * 2);
        int i = 0;
        while (i < value.length) {
            String hex = Integer.toHexString(value[i] & 0xFF);
            if (hex.length() == 1) {
                builder.append('0');
            }
            builder.append(hex);
            ++i;
        }
        return builder.toString();
    }

    public static String convertByteArrayToBitString(byte[] bytes) {
        return ByteUtil.convertByteArrayToBitString(bytes, bytes.length);
    }

    public static String convertByteArrayToBitString(byte[] bytes, int length) {
        if (bytes.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            String bits = Integer.toString(bytes[i] & 0xFF, 2);
            int j = 0;
            while (j < 8 - bits.length()) {
                builder.append('0');
                ++j;
            }
            builder.append(bits).append(' ');
            ++i;
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static InputStream createByteStream(String bitString) {
        return new ByteArrayInputStream(ByteUtil.convertBitStringToFastByteArray(bitString));
    }

    public static InputStream createByteStreamFromHexBytes(String hexString) {
        return new ByteArrayInputStream(ByteUtil.convertHexStringToByteArray(hexString));
    }

    public static byte[] combine(byte[] first, byte[] second) {
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static boolean isEmpty(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            if ((bytes[i] & 0x7F) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] combine(byte[] first, int firstOffset, int firstLength, byte[] second, int secondOffset, int secondLength) {
        int fLen = Math.min(firstLength, first.length - firstOffset);
        int sLen = Math.min(secondLength, second.length - secondOffset);
        int totalLength = fLen + sLen;
        byte[] result = new byte[totalLength];
        System.arraycopy(first, firstOffset, result, 0, fLen);
        System.arraycopy(second, secondOffset, result, fLen, sLen);
        return result;
    }
}

