/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.InputStream;
import org.openfast.NumericValue;
import org.openfast.ScalarValue;
import org.openfast.template.type.codec.IntegerCodec;
import org.openfast.template.type.codec.TypeCodec;

public final class NullableSignedInteger
extends IntegerCodec {
    private static final long serialVersionUID = 1L;

    NullableSignedInteger() {
    }

    public byte[] encodeValue(ScalarValue value) {
        if (value.isNull()) {
            return TypeCodec.NULL_VALUE_ENCODING;
        }
        NumericValue intValue = (NumericValue)value;
        if (intValue.toLong() >= 0L) {
            return TypeCodec.INTEGER.encodeValue(intValue.increment());
        }
        return TypeCodec.INTEGER.encodeValue(intValue);
    }

    public ScalarValue decode(InputStream in) {
        NumericValue numericValue = (NumericValue)TypeCodec.INTEGER.decode(in);
        long value = numericValue.toLong();
        if (value == 0L) {
            return null;
        }
        if (value > 0L) {
            return numericValue.decrement();
        }
        return numericValue;
    }

    public boolean isNullable() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

