/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openfast.ScalarValue;
import org.openfast.StringValue;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.ByteVectorType;
import org.openfast.template.type.DecimalType;
import org.openfast.template.type.SignedIntegerType;
import org.openfast.template.type.StringType;
import org.openfast.template.type.UnsignedIntegerType;
import org.openfast.template.type.codec.TypeCodec;
import org.openfast.util.Util;

public abstract class Type
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map TYPE_NAME_MAP = new LinkedHashMap();
    private final String name;
    public static final Type U8 = new UnsignedIntegerType(8, 256L);
    public static final Type U16 = new UnsignedIntegerType(16, 65536L);
    public static final Type U32 = new UnsignedIntegerType(32, 0xFFFFFFFFL);
    public static final Type U64 = new UnsignedIntegerType(64, Long.MAX_VALUE);
    public static final Type I8 = new SignedIntegerType(8, -128L, 127L);
    public static final Type I16 = new SignedIntegerType(16, -32768L, 32767L);
    public static final Type I32 = new SignedIntegerType(32, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final Type I64 = new SignedIntegerType(64, Long.MIN_VALUE, Long.MAX_VALUE);
    public static final Type STRING = new StringType("string", TypeCodec.ASCII, TypeCodec.NULLABLE_ASCII){
        private static final long serialVersionUID = 1L;

        public ScalarValue getValue(byte[] bytes) {
            return new StringValue(new String(bytes));
        }

        public ScalarValue getValue(byte[] bytes, int offset, int length) {
            return new StringValue(new String(bytes, offset, length));
        }
    };
    public static final Type ASCII = new StringType("ascii", TypeCodec.ASCII, TypeCodec.NULLABLE_ASCII){
        private static final long serialVersionUID = 1L;

        public ScalarValue getValue(byte[] bytes) {
            return new StringValue(new String(bytes));
        }

        public ScalarValue getValue(byte[] bytes, int offset, int length) {
            return new StringValue(new String(bytes, offset, length));
        }
    };
    public static final Type UNICODE = new StringType("unicode", TypeCodec.UNICODE, TypeCodec.NULLABLE_UNICODE){
        private static final long serialVersionUID = 1L;

        public ScalarValue getValue(byte[] bytes) {
            try {
                return new StringValue(new String(bytes, "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public ScalarValue getValue(byte[] bytes, int offset, int length) {
            try {
                return new StringValue(new String(bytes, offset, length, "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static final Type BYTE_VECTOR = new ByteVectorType();
    public static final Type DECIMAL = new DecimalType();
    public static final Type[] ALL_TYPES = new Type[]{U8, U16, U32, U64, I8, I16, I32, I64, STRING, ASCII, UNICODE, BYTE_VECTOR, DECIMAL};
    public static final Type[] INTEGER_TYPES = new Type[]{U8, U16, U32, U64, I8, I16, I32, I64};

    public Type(String typeName) {
        this.name = typeName;
        TYPE_NAME_MAP.put(typeName, this);
    }

    public static Type getType(String typeName) {
        if (!TYPE_NAME_MAP.containsKey(typeName)) {
            throw new IllegalArgumentException("The type named " + typeName + " does not exist.  Existing types are " + Util.collectionToString(TYPE_NAME_MAP.keySet()));
        }
        return (Type)TYPE_NAME_MAP.get(typeName);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String serialize(ScalarValue value) {
        return value.toString();
    }

    public abstract TypeCodec getCodec(Operator var1, boolean var2);

    public abstract ScalarValue getValue(String var1);

    public abstract ScalarValue getDefaultValue();

    public abstract boolean isValueOf(ScalarValue var1);

    public void validateValue(ScalarValue value) {
    }

    public static Map getRegisteredTypeMap() {
        return TYPE_NAME_MAP;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public ScalarValue getValue(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public ScalarValue getValue(byte[] bytes, int offset, int length) {
        throw new UnsupportedOperationException();
    }
}

