% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mftot.R
\name{mftot}
\alias{mftot}
\title{Evaluate the Fisher Information Matrix (FIM)}
\usage{
mftot(model_switch, groupsize, ni, xt, x, a, bpop, d, sigma, docc,
  poped.db)
}
\arguments{
\item{model_switch}{A matrix that is the same size as xt, specifying which model each sample belongs to.}

\item{groupsize}{A vector of the number of individuals in each group.}

\item{ni}{A vector of the number of samples in each group.}

\item{xt}{A matrix of sample times.  Each row is a vector of sample times for a group.}

\item{x}{A matrix for the discrete design variables.  Each row is a group.}

\item{a}{A matrix of covariates.  Each row is a group.}

\item{bpop}{The fixed effects parameter values.  Supplied as a vector.}

\item{d}{A between subject variability matrix (OMEGA in NONMEM).}

\item{sigma}{A residual unexplained variability matrix (SIGMA in NONMEM).}

\item{docc}{A between occasion variability matrix.}

\item{poped.db}{A PopED database.}
}
\value{
As a list:
\item{ret}{The FIM}
\item{poped.db}{A PopED database}
}
\description{
Compute the FIM given specific model(s), parameters, design and methods.
}
\examples{
library(PopED)

############# START #################
## Create PopED database
## (warfarin model for optimization)
#####################################

## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## Optimization using an additive + proportional reidual error  
## to avoid sample times at very low concentrations (time 0 or very late samples).

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_fun=ff.PK.1.comp.oral.sd.CL,
                                  fg_fun=sfg,
                                  fError_fun=feps.add.prop,
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=c(0.01,0.25),
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0.01,
                                  maxxt=120,
                                  a=70,
                                  mina=0.01,
                                  maxa=100)

############# END ###################
## Create PopED database
## (warfarin model for optimization)
#####################################


mftot(model_switch=poped.db$design$model_switch,
      groupsize=poped.db$design$groupsize,
      ni=poped.db$design$ni,
      xt=poped.db$design$xt,
      x=poped.db$design$x,
      a=poped.db$design$a,
      bpop=poped.db$parameters$param.pt.val$bpop,
      d=poped.db$parameters$param.pt.val$d,
      sigma=poped.db$parameters$sigma,
      docc=poped.db$parameters$param.pt.val$docc,
      poped.db)["ret"]

}
\seealso{
For an easier function to use, please see \code{\link{evaluate.fim}}.

Other FIM: \code{\link{LinMatrixH}},
  \code{\link{LinMatrixLH}}, \code{\link{LinMatrixL_occ}},
  \code{\link{calc_ofv_and_fim}},
  \code{\link{ed_laplace_ofv}}, \code{\link{ed_mftot}},
  \code{\link{efficiency}},
  \code{\link{evaluate.e.ofv.fim}},
  \code{\link{evaluate.fim}}, \code{\link{gradf_eps}},
  \code{\link{mf3}}, \code{\link{mf7}},
  \code{\link{ofv_criterion}}, \code{\link{ofv_fim}}
}
\concept{FIM}
\keyword{internal}
