% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inv.R
\name{inv}
\alias{inv}
\title{Compute the inverse of a matrix}
\usage{
inv(mat, method = 1, tol = .Machine$double.eps,
  pseudo_on_fail = TRUE, ...)
}
\arguments{
\item{mat}{A matrix}

\item{method}{Which method to use. 1 is Cholesky \code{chol2inv(chol(mat)}, 
2 is using \code{solve(mat)} and 3 is the Moore-Penrose generalized inverse (pseudoinverse).}

\item{tol}{The tolerance at which we should identify a singular value as zero (used in pseudoinverse calculation).}

\item{pseudo_on_fail}{If another method fails should the Moore-Penrose generalized inverse (pseudoinverse) be used?}

\item{...}{Not used.}
}
\value{
The inverse matrix
}
\description{
Function computes the inverse of a matrix.
}
\keyword{internal}
