% Generated by roxygen2 (4.0.1): do not edit by hand
\name{expectation.mm}
\alias{expectation.mm}
\title{Compute the expected distance, MM under the Hamming distance}
\usage{
expectation.mm(theta, perm.length, dist.name = "kendall")
}
\arguments{
\item{theta}{real dispersion parameter}

\item{perm.length}{length of the permutation in the considered model}

\item{dist.name}{optional name of the distance used in the MM. One of: kendall (default), cayley, hamming, ulam}
}
\value{
The expected distance under the MM
}
\description{
Compute the expected distance in the MM under the Hamming distance
}
\examples{
expectation.mm( 1, 7, "kendall" )
expectation.mm( 2, 5, "cayley" )
expectation.mm( 2, 4, "hamming" )
expectation.mm( 1, 6, "ulam" )
}

