% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_sequence.R
\name{strip_sequence_Spectronaut}
\alias{strip_sequence_Spectronaut}
\title{Strip sequence from Spectronaut outputs}
\usage{
strip_sequence_Spectronaut(data, column, convert_column)
}
\arguments{
\item{data}{A dataframe with a column containing peptide sequences to be stripped}

\item{column}{The name of the column containing the peptide sequences to be stripped.}

\item{convert_column}{The name of the column where the stripped sequences will be stored.}
}
\value{
A dataframe with a column containing stripped sequence
}
\description{
This function takes Spectronaut output containing a column with peptide sequences to be stripped
and converts it into a new dataframe with the stripped sequence
}
\examples{
library(data.table)
data <- data.table(
  EG.IntPIMID = c(
    "_[+42]M[-16]DDREDLVYQAK_",
    "_EAAENSLVAYK_",
    "_IEAELQDIC[+57]NDVLELLDK_"
  ),
  Condition = c("A", "B", "B")
)
converted_data <- strip_sequence_Spectronaut(data, 'EG.IntPIMID', 'Sequence')

}
