% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographics.R
\name{addDemographics}
\alias{addDemographics}
\title{Compute demographic characteristics at a certain date}
\usage{
addDemographics(
  x,
  indexDate = "cohort_start_date",
  age = TRUE,
  ageName = "age",
  ageMissingMonth = 1,
  ageMissingDay = 1,
  ageImposeMonth = FALSE,
  ageImposeDay = FALSE,
  ageGroup = NULL,
  missingAgeGroupValue = "None",
  sex = TRUE,
  sexName = "sex",
  missingSexValue = "None",
  priorObservation = TRUE,
  priorObservationName = "prior_observation",
  priorObservationType = "days",
  futureObservation = TRUE,
  futureObservationName = "future_observation",
  futureObservationType = "days",
  dateOfBirth = FALSE,
  dateOfBirthName = "date_of_birth",
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the date to compute the
demographics characteristics.}

\item{age}{TRUE or FALSE. If TRUE, age will be calculated relative to
indexDate.}

\item{ageName}{Age variable name.}

\item{ageMissingMonth}{Month of the year assigned to individuals with missing
month of birth.}

\item{ageMissingDay}{day of the month assigned to individuals
with missing day of birth.}

\item{ageImposeMonth}{TRUE or FALSE. Whether the month of the date of birth
will be considered as missing for all the individuals.}

\item{ageImposeDay}{TRUE or FALSE. Whether the day of the date of birth
will be considered as missing for all the individuals.}

\item{ageGroup}{if not NULL, a list of ageGroup vectors.}

\item{missingAgeGroupValue}{Value to include if missing age.}

\item{sex}{TRUE or FALSE. If TRUE, sex will be identified.}

\item{sexName}{Sex variable name.}

\item{missingSexValue}{Value to include if missing sex.}

\item{priorObservation}{TRUE or FALSE. If TRUE, days of between the start
of the current observation period and the indexDate will be calculated.}

\item{priorObservationName}{Prior observation variable name.}

\item{priorObservationType}{Whether to return a "date" or the number of
"days".}

\item{futureObservation}{TRUE or FALSE. If TRUE, days between the
indexDate and the end of the current observation period will be
calculated.}

\item{futureObservationName}{Future observation variable name.}

\item{futureObservationType}{Whether to return a "date" or the number of
"days".}

\item{dateOfBirth}{TRUE or FALSE, if true the date of birth will be return.}

\item{dateOfBirthName}{dateOfBirth column name.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
cohort table with the added demographic information columns.
}
\description{
Compute demographic characteristics at a certain date
}
\examples{
\donttest{
library(PatientProfiles)
cdm <- mockPatientProfiles()
cdm$cohort1 \%>\%
  addDemographics()
mockDisconnect(cdm = cdm)
}

}
