% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableSummarised.R
\name{tableLargeScaleCharacteristics}
\alias{tableLargeScaleCharacteristics}
\title{Format a summarised_large_scale_characteristics object into a visual table.}
\usage{
tableLargeScaleCharacteristics(
  result,
  type = "gt",
  formatEstimateName = c(`N (\%)` = "<count> (<percentage>\%)"),
  splitStrata = TRUE,
  header = c("cdm name", "cohort name", "strata", "window name"),
  topConcepts = 10,
  minCellCount = 5
)
}
\arguments{
\item{result}{A summarised_large_scalecharacteristics object.}

\item{type}{Output type ("gt" or "flextable").}

\item{formatEstimateName}{Named list of estimate name's to join, sorted by
computation order. Indicate estimate_name's between <...>.}

\item{splitStrata}{Whether to split strata_group and starta_level to multiple
columns.}

\item{header}{Specify the headers of the table.}

\item{topConcepts}{Number of concepts to restrict the table.}

\item{minCellCount}{Minimum number of counts to display.}
}
\value{
A formatted table.
}
\description{
`r lifecycle::badge("experimental")`
}
\examples{
\dontrun{
library(DBI)
library(duckdb)
library(CDMConnector)

con <- dbConnect(duckdb(), eunomia_dir())
cdm <- cdmFromCon(con = con, cdmSchema = "main", writeSchema = "main")
cdm <- generateConceptCohortSet(
  cdm = cdm,
  conceptSet = list("viral_pharyngitis" = 4112343),
  name = "my_cohort"
)
result <- summariseLargeScaleCharacteristics(
  cohort = cdm$my_cohort,
  eventInWindow = "condition_occurrence",
  episodeInWindow = "drug_exposure"
)
tableLargeScaleCharacteristics(result)
}

}
