% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{detectVariables}
\alias{detectVariables}
\title{Detect automatically variables with a certain classification}
\usage{
detectVariables(
  table,
  variableType,
  exclude = c("person_id", "subject_id", "cohort_definition_id", "cohort_name",
    "strata_name", "strata_level")
)
}
\arguments{
\item{table}{Tibble}

\item{variableType}{Classification of interest, choice between
"numeric", "date", "binary" and "categorical"}

\item{exclude}{Variables to exclude}
}
\value{
Variables in x with the desired classification
}
\description{
Detect automatically variables with a certain classification
}
\examples{
\donttest{
library(PatientProfiles)
x <- dplyr::tibble(
  person_id = c(1, 2),
  start_date = as.Date(c("2020-05-02", "2021-11-19")),
  asthma = c(0, 1)
)
detectVariables(x, "numeric")
}

}
