% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logging.R
\name{createLogSettings}
\alias{createLogSettings}
\title{Create the settings for logging the progression of the analysis}
\usage{
createLogSettings(
  verbosity = "DEBUG",
  timeStamp = TRUE,
  logName = "runPlp Log"
)
}
\arguments{
\item{verbosity}{Sets the level of the verbosity. If the log level is at or higher in priority than the logger threshold, a message will print. The levels are:
\itemize{
\item DEBUG Highest verbosity showing all debug statements
\item TRACE Showing information about start and end of steps
\item INFO Show informative information (Default)
\item WARN Show warning messages
\item ERROR Show error messages
\item FATAL Be silent except for fatal errors
}}

\item{timeStamp}{If TRUE a timestamp will be added to each logging statement. Automatically switched on for TRACE level.}

\item{logName}{A string reference for the logger}
}
\value{
An object of class \code{logSettings} containing the settings for the logger
}
\description{
Create the settings for logging the progression of the analysis
}
\details{
Returns an object of class \code{logSettings} that specifies the logger settings
}
\examples{
# create a log settings object with DENUG verbosity, timestamp and log name 
# "runPlp Log". This needs to be passed to `runPlp`.
createLogSettings(verbosity = "DEBUG", timeStamp = TRUE, logName = "runPlp Log")
}
