% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaveLoadPlp.R
\name{savePlpShareable}
\alias{savePlpShareable}
\title{Save the plp result as json files and csv files for transparent sharing}
\usage{
savePlpShareable(result, saveDirectory, minCellCount = 10)
}
\arguments{
\item{result}{An object of class runPlp with development or validation results}

\item{saveDirectory}{The directory the save the results as csv files}

\item{minCellCount}{Minimum cell count for the covariateSummary and certain evaluation results}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{                       The directory path where the results were saved
}\if{html}{\out{</div>}}
}
\description{
Save the plp result as json files and csv files for transparent sharing
}
\details{
Saves the main results json/csv files (these files can be read by the shiny app)
}
\examples{
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000)
saveLoc <- file.path(tempdir(), "savePlpShareable")
results <- runPlp(plpData, saveDirectory = saveLoc)
newSaveLoc <- file.path(tempdir(), "savePlpShareable", "saved")
path <- savePlpShareable(results, newSaveLoc)
# show the saved result
dir(newSaveLoc, full.names = TRUE, recursive = TRUE)

# clean up
unlink(saveLoc, recursive = TRUE)
unlink(newSaveLoc, recursive = TRUE)
}
}
