\name{discreteNameToValue}
\alias{discreteNameToValue}
\title{Convert encoding name(s) to discrete value(s).}
\usage{
  discreteNameToValue(par, name)
}
\arguments{
  \item{par}{[\code{\link{Param}}]\cr Discrete parameter or
  discrete vector.}

  \item{name}{[\code{character}]\cr Name (string) encoding
  the value for a discrete parameter, or a character vector
  of names for a discrete vector.}
}
\value{
  [any]. Parameter value for a discrete parameter or a list
  of values for a discrete vector.
}
\description{
  Convert encoding name(s) to discrete value(s).
}
\examples{
p <- makeDiscreteParam("u", values=c(x1="a", x2="b", x3="b"))
discreteNameToValue(p, "x3")
}

