% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Loggers.R
\name{addDefaultEmailLogger}
\alias{addDefaultEmailLogger}
\title{Add the default e-mail logger}
\usage{
addDefaultEmailLogger(
  mailSettings,
  label = Sys.info()["nodename"],
  name = "DEFAULT_EMAIL_LOGGER",
  test = FALSE
)
}
\arguments{
\item{mailSettings}{Arguments to be passed to the \code{sendmail} function in the \code{sendmailR} package (except
subject and msg).}

\item{label}{A label to be used in the e-mail subject to identify a run. By default the
name of the computer is used.}

\item{name}{A name for the logger.}

\item{test}{If TRUE, a message will be displayed on the console instead of sending an
e-mail.}
}
\description{
Add the default e-mail logger
}
\details{
Creates a logger that writes to e-mail using the "FATAL" threshold and the
\code{\link{layoutEmail}} layout. This function uses the \code{sendmailR} package. Please make sure
your e-mail settings are correct by using the \code{sendmailR} package before using those settings here.
\code{ParallelLogger} will not display any messages if something goes wrong when sending the e-mail.
}
\section{Using GMail}{


To use a GMail account, make sure to enable 2-step verification on your 
Google account (see 'Security'). Click on 2-Step Verification, and 
scroll down to 'App passwords'. Here, you can create an app-specific password
to be used with \code{ParallelLogger}. You can set 
\code{host.name = "smtp.gmail.com:587"}, and be sure to use 
\code{engine = "curl"}.
}

\examples{
mailSettings <- list(
  from = "someone@gmail.com",
  to = "someone_else@gmail.com",
  engine = "curl",
  engineopts  = list(
    username = "someone@gmail.com",
    password = "Secret!"
  ), 
  control = list(
    host.name = "smtp.gmail.com:587"
  )
)

# Setting test to TRUE in this example so we don't really send an e-mail:
addDefaultEmailLogger(mailSettings, "My R session", test = TRUE)
logFatal("Something bad")

unregisterLogger("DEFAULT_EMAIL_LOGGER")
}
