% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParallelInit.R
\name{ParallelInit}
\alias{ParallelInit}
\title{As a data ParallelIniting function, sets some global variables that are not visible to the user}
\usage{
ParallelInit(
  Fpath = "",
  fn = "",
  dsmformula = "",
  nblock = 6,
  ncore = 2,
  Fc = 1
)
}
\arguments{
\item{Fpath}{: The file path to the CSV file}

\item{fn}{: Name of the folder in which the soil data is stored}

\item{dsmformula}{: Symbolic description of a soil fitting model}

\item{nblock}{: the number of blocks for data cutting}

\item{ncore}{: Computes the CPU's kernel in parallel(fill in according to the computer configuration)}

\item{Fc}{: the encoding of file}
}
\description{
As a data ParallelIniting function, sets some global variables that are not visible to the user
}
\examples{
############################################################################
## Example code                                                           ##
## Select your own reading method, as shown below                         ##
############################################################################
mydatas <- system.file("extdata", "all.input.csv", package = "ParallelDSM")
sampledatas <- system.file("extdata", "covariate", package = "ParallelDSM")
ParallelInit(mydatas,sampledatas,"socd030 ~ twi + dem + pa")

############################################################################
## If you want to use test cases, load the relevant data sets             ##
############################################################################
# Select the data set that comes with this package
# data("df.input", package = "ParallelDSM")
# data("df.dem", package = "ParallelDSM")

############################################################################
##  Use the data file references that come with this package              ##
############################################################################
# sampledatas <- system.file("extdata", "covariate", package = "ParallelDSM")

############################################################################
## Select your own data file references, as shown below                   ##
############################################################################
# sampledatas <- "C:/mySampleDatas/"

############################################################################
## Use ParallelInit functions to process the data that is loaded in       ##
############################################################################
# ParallelInit(myinput,sampledata,"socd030 ~ twi + procur + dem")

############################################################################
## This function is the main function that performs parallel computations ##
## The outpath field refers to the filename of the data output            ##
## The mymodels field has three modes to choose from: QRF,RF and MLR      ##
## 'QRF' stands for Quantile Regression Forest Model Prediction Method    ##
## 'RF' stands for Random Forest Model Prediction Method                  ##
## 'MLR' stands for Multiple Linear Regression Prediction Model           ##
## 'from' and 'to' are reserved fields that can be left unused by the user##
############################################################################
# ParallelComputing(outpath = "myoutputs", mymodels = "MLR")

}
\references{
{
Breiman, L. (2001). Random forests. Mach. Learn. 45, 5–32.
Meinshausen, N. (2006) "Quantile Regression Forests", Journal of Machine Learning Research 7,
983-999 http://jmlr.csail.mit.edu/papers/v7/
}
}
