% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MergingTiles.R
\name{MergingTiles}
\alias{MergingTiles}
\title{A function that combines the results of parallel cutting into a single file}
\usage{
MergingTiles(df_dem, f.i.d, f.iblock, n.block, f.o.d, f.suffix)
}
\arguments{
\item{df_dem}{: The predicted source file before merging}
\item{f.i.d}{: Enter the absolute path to the file}
\item{f.iblock}{: The filename prefix of the resulting result}
\item{n.block}{: The number of blocks cut is calculated in parallel}
\item{f.o.d}{: The absolute output path of the file}
\item{f.suffix}{: The suffix for the output of the file}


}
\description{
A function that combines the results of parallel cutting into a single file
}
\examples{
\donttest{
# you must have a file, which is name "myres"
# Merging files, for example:
# f.input.directory <- c("e:/3_20190603_R/results/mapping/test_merging/")
# f.input.iblock <- c("sics030_")
# n.block <- 100
# f.output.directory <- c("e:/3_20190603_R/results/mapping/erpu.sics030_fuse/")
# f.output.suffix <- c("sics030_together.tif")
# Naming rules: file.name.directory + file.name.iblock + ".tif"

rmap_dem <- raster("E:/12_Parallel_Test_Paper_R/covariate/250m/dem.tif")
spdf_dem <- as(rmap_dem,"SpatialPointsDataFrame")
df_dem <- as.data.frame(spdf_dem)
# mergeing results together
n.block <- 100
f.i.d <- c("E:/12_Parallel_Test_Paper_R/results/mapping_250m/")
f.o.d <- c("E:/12_Parallel_Test_Paper_R/results/mapping_250m_merge/")
f.iblock <- c("mlr.ak05.")
f.suffix <- c("mlr.ak05.tif")
MergingTiles(df_dem, f.i.d, f.iblock, n.block, f.o.d, f.suffix)
}
}
