% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelEstimateObject.R
\name{summary.PanelEstimate}
\alias{summary.PanelEstimate}
\title{Get summaries of PanelEstimate objects and calculations}
\usage{
\method{summary}{PanelEstimate}(
  object,
  confidence.level = NULL,
  verbose = FALSE,
  bias.corrected = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{PanelEstimate} object}

\item{confidence.level}{Confidence level to be used for confidence interval calculations. Must be numeric between 0 and 1. If NULL, confidence level from \code{PanelEstimate()} specification is used.}

\item{verbose}{logical indicating whether or not output should be printed in an expanded form. Default is FALSE}

\item{bias.corrected}{logical indicating whether or not bias corrected estimates should be provided. Default is FALSE. This argument only applies for standard errors calculated with the bootstrap.}

\item{...}{optional additional arguments. Currently, no additional arguments are supported.}
}
\description{
\code{summary.PanelEstimate} takes an object returned by
\code{PanelEstimate}, and returns a summary table of point
estimates and confidence intervals
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
# create subset of data for simplicity
PM.results <- PanelMatch(panel.data = dem.sub.panel, lag = 4, 
                         refinement.method = "ps.match", 
                         match.missing = TRUE, 
                         covs.formula = ~ tradewb,
                         size.match = 5, qoi = "att",
                         lead = 0:4, 
                         forbid.treatment.reversal = FALSE)
PE.results <- PanelEstimate(sets = PM.results, 
                            panel.data = dem.sub.panel, 
                            se.method = "unconditional")
summary(PE.results)
summary(PE.results, confidence.level = .9)

}
