% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_createRawDataframe.R
\name{wrcc_createRawDataframe}
\alias{wrcc_createRawDataframe}
\title{Obtain WRCC data and parse into a tibble}
\usage{
wrcc_createRawDataframe(startdate = strftime(lubridate::now(),
  "\%Y010100", tz = "UTC"), enddate = strftime(lubridate::now(),
  "\%Y\%m\%d23", tz = "UTC"), unitID = NULL, clusterDiameter = 1000,
  baseUrl = "https://wrcc.dri.edu/cgi-bin/wea_list2.pl",
  saveFile = NULL, flagAndKeep = FALSE)
}
\arguments{
\item{startdate}{Desired start date (integer or character representing YYYYMMDD[HH]).}

\item{enddate}{Desired end date (integer or character representing YYYYMMDD[HH]).}

\item{unitID}{Station identifier (will be upcased).}

\item{clusterDiameter}{Diameter in meters used to determine the number of clusters (see \code{addClustering}).}

\item{baseUrl}{Base URL for data queries.}

\item{saveFile}{Optional filename where raw CSV will be written.}

\item{flagAndKeep}{Flag, rather then remove, bad data during the QC process.}
}
\value{
Raw tibble of WRCC data.
}
\description{
Obtains monitor data from a WRCC webservice and converts
it into a quality controlled, metadata enhanced "raw" tibble
ready for use with all \code{raw_~} functions.

Steps involved include:

\enumerate{
 \item{download CSV text}
 \item{parse CSV text}
 \item{apply quality control}
 \item{apply clustering to determine unique deployments}
 \item{enhance metadata to include: elevation, timezone, state, country, site name}
}
}
\note{
The downloaded CSV may be saved to a local file by providing an argument to the \code{saveFile} parameter.

Monitor unitIDs can be found at https://wrcc.dri.edu/cgi-bin/smoke.pl.
}
\examples{
\dontrun{
tbl <- wrcc_createRawDataframe(20150701, 20150930, unitID = 'SM16')
}

}
\references{
\href{https://wrcc.dri.edu/cgi-bin/smoke.pl}{Fire Cache Smoke Monitoring Archive}
}
\seealso{
\code{\link{wrcc_downloadData}}

\code{\link{wrcc_parseData}}

\code{\link{wrcc_qualityControl}}

\code{\link{addClustering}}
}
\keyword{WRCC}
