% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openaq_createDataDataframes.R
\name{openaq_createDataDataframes}
\alias{openaq_createDataDataframes}
\title{Create OpenAQ Data Dataframe}
\usage{
openaq_createDataDataframes(df, parameters = NULL)
}
\arguments{
\item{df}{a OpenAQ dataframe after metadata enhancement}

\item{parameters}{pollutant name}
}
\value{
A \code{data} dataframe for use in a emph{ws_monitor} object.
}
\description{
After addtional columns(i.e. \code{'datetime'}, \code{'stateCode'}, and \code{'monitorID'}) 
have been applied to an OpenAQ dataframe,
we can extract the PM2.5 values and store them in a \code{data} dataframe
organized as time-by-monitor.

The first column of the returned dataframe is named \code{'datetime'} and
contains a \code{POSIXct} time in UTC. Additional columns contain data
for each separate monitorID. 

Available parameters are limited to:
PM2.5, PM10, ozone (O3), sulfur dioxide (SO2), nitrogen dioxide (NO2), 
carbon monoxide (CO), and black carbon (BC)
\enumerate{
\item{pm25}{ -- PM2.5}
\item{pm10}{ -- PM10}
\item{o3}{ -- ozone }
\item{so2}{ -- sulfer dioxide }
\item{no2}{ -- nitrogen dioxide}
\item{co}{ -- carbon monoxide}
\item{bc}{ -- black carbon}
}
}
\keyword{OpenAQ}

