% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_dailyThreshold.R
\name{monitor_dailyThreshold}
\alias{monitor_dailyThreshold}
\title{Calculate Daily Counts of Values At or Above a Threshold}
\usage{
monitor_dailyThreshold(ws_monitor, threshold = "unhealthy",
  dayStart = "midnight", minHours = 0, na.rm = TRUE)
}
\arguments{
\item{ws_monitor}{emph{ws_monitor} object}

\item{threshold}{AQI level name (e.g. \code{"unhealthy"}) or numerical threshold at or above which a measurement is counted}

\item{dayStart}{one of \code{"sunset|midnight|sunrise"}}

\item{minHours}{minimum number of hourly observations required}

\item{na.rm}{logical value indicating whether NA values should be ignored}
}
\value{
A emph{ws_monitor} object with a daily count of hours at or above \code{threshold}.
}
\description{
Calculates the number of hours per day each monitor in \code{ws_monitor} was at or above a given threshold
}
\details{
\strong{NOTE:} The returned counts include values at OR ABOVE the given threshold; this applies to both categories and values. 
For example, passing a \code{threshold} argument = "unhealthy" will return a daily count of values that are unhealthy, 
very unhealthy, or extreme (i.e. >= 55.5), as will passing a \code{threshold} argument = 55.5.

AQI levels for \code{threshold} argument = one of \code{"good|moderate|USG|unhealthy|very unhealthy|extreme"}

Sunrise and sunset times are calculated based on the first monitor encountered.
This should be accurate enough for all use cases involving co-located monitors. Monitors
from different regions should have daily statistics calculated separately.

The returned \emph{ws_monitor} object has a daily time axis where each time is set to 00:00, local time.
}
\examples{
N_M <- monitor_subset(Northwest_Megafires, tlim=c(20150801,20150831))
Twisp <- monitor_subset(N_M, monitorIDs='530470009')
Twisp_daily <- monitor_dailyThreshold(Twisp, "unhealthy", dayStart='midnight', minHours=1)
monitorPlot_timeseries(Twisp_daily, type='h', lwd=6, ylab="Hours")
title("Twisp, Washington Hours per day Above 'Unhealthy', 2015")
}
\keyword{ws_monitor}

