% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_feature_correction.R
\name{plr_saturation_removal}
\alias{plr_saturation_removal}
\title{Removing Saturated Data}
\usage{
plr_saturation_removal(df, var_list, sat_limit, power_thresh = 0.99)
}
\arguments{
\item{df}{A dataframe containing pv data.}

\item{var_list}{A list of the dataframe's standard variable names, obtained from
the output of \code{\link{plr_variable_check}}.}

\item{sat_limit}{An upper limit on power saturation. This is multiplied by the
power threshold, and power values above this point are filtered from
the dataframe. The value depends on the system's inverter.}

\item{power_thresh}{An upper limit on power.}
}
\value{
Returns passed data frame with rows removed which contain power values above the specified threshold
}
\description{
Tests for readings which may indicate saturation of the system.
Removes values above the power saturation limit (calculated by multiplying
sat_limit and power_thresh).
}
\examples{
# build var_list
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
test_dfc_removed_saturation <- plr_saturation_removal(test_dfc, var_list,
                                                      sat_limit = 3000, power_thresh = 0.99)

}
