% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty.R
\name{plr_bootstrap_uncertainty}
\alias{plr_bootstrap_uncertainty}
\title{Bootstrap: Resampling data going into each Model}
\usage{
plr_bootstrap_uncertainty(
  df,
  n,
  fraction = 0.65,
  var_list,
  model,
  by = "month",
  power_var = "power_var",
  time_var = "time_var",
  data_cutoff = 100,
  np = NA,
  pred = NULL
)
}
\arguments{
\item{df}{A dataframe containing pv data.}

\item{n}{(numeric) Number of samples to take. The higher the n value, the longer it 
takes to complete, but the results become more accurate as well.}

\item{fraction}{The fraction of data that constitutes a resample for the bootstrap.}

\item{var_list}{A list of variables obtained through \code{\link{plr_variable_check}}.}

\item{model}{the String name of the model to bootstrap. Select from: \itemize{
\item "xbx" (\code{\link{plr_xbx_model}}),
\item "correction" (\code{\link{plr_xbx_utc_model}}),
\item "pvusa" (\code{\link{plr_pvusa_model}}),
 \item or "6k" (\code{\link{plr_6k_model}}).
}}

\item{by}{String, either "day", "week", or "month". Time over which to perform
\code{\link{plr_yoy_regression}}.}

\item{power_var}{Variable name of power in the dataframe. This must be the
variable's name after being put through your selected model. Typically power_var}

\item{time_var}{Variable name of time in the dataframe. This must be the
variable's name after being put through your selected model. Typically time_var}

\item{data_cutoff}{The number of data points needed to keep a value in the
final table. Regressions over less than this number and their data will be discarded.}

\item{np}{The system's reported name plate power. See \code{\link{plr_6k_model}}.}

\item{pred}{passed to predict_data in model call. See \code{\link{plr_xbx_model}}
for an example.}
}
\value{
Returns PLR value and uncertainty calculated with bootstrap of data going into power correction models
}
\description{
This function determines the uncertainty of a PLR measurement
through resampling data for each model, prior to putting the data through the
model.
}
\examples{
# build var_list

\donttest{
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
xbx_mbm_plr_uncertainty <- plr_bootstrap_uncertainty(test_dfc, n = 2, 
                                                     fraction = 0.65, by = 'month',
                                                     power_var = 'power_var', time_var = 'time_var',
                                                     var_list = var_list, model = "xbx",
                                                     data_cutoff = 10, np = NA,
                                                     pred = NULL)
}

}
