% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hillanalysis.r
\name{hillanalysis}
\alias{hillanalysis}
\title{Hill Isotherm Analysis Non-Linear Form}
\usage{
hillanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{equilibrium capacity}

\item{Qe}{adsorbed capacity}
}
\description{
Hill isotherm model shows the connection of different species of homogeneous surfaces. It assumes that the adsorption is a cooperative phenomenon, with a ligand binding activity at one  part of a macromolecule that may affect the different binding sites of that same macromolecule.
}
\examples{
Ce <- c(0.001, 0.0026, 0.0125, 0.031, 0.056)
Qe <- c(0.02, 0.072, 0.146, 0.15, 0.151)
hillanalysis(Ce, Qe)
}
\references{
Tanzifi, M., Karimipour, K., Hoseini, S., Ali, I.(2017). Artificial neural network optimization for methyl orange adsorption onto polyaniline nano-adsorbent: Kinetic, isotherms and thermodynamics. Journal of Molecular Liquids, 2017, p.11. DOI:10.1016/j.molliq.2017.08.122

Saadi, R., Saadi, z., Fazaeli, R., Fard, N.E.(2015). Monolayer and multilayer adsorption models for sorption aqueous media. Korean Journal of Chemical Engineering, 2015, p.5. DOI: 10.007/s11814-015-0053-7

Larimi, S.G., Moghadamnia, A.A., Najafpour, G.(2016). Kinetics and isotherm studies of the Immobilized Lipase on Chitosan Support. International Journal of Engineering, 2026, p.12. DOI: 10.5829/idosi.ije.2016.29.10a.01
}
\author{
Amiela D. Suerte

Carl Luis P. Flestado

C.C. Deocaris
}
