% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_PSweight.R
\name{summary.PSweight}
\alias{summary.PSweight}
\title{Summarize a PSweight object}
\usage{
\method{summary}{PSweight}(object, contrast = NULL, type = "DIF", ...)
}
\arguments{
\item{object}{a PSweight object obtained from the \code{\link{PSweight}} function.}

\item{contrast}{a vector or matrix specifying the causal contrast of interest. The average causal effects will be
defined by such contrats. For multiple treatments, the contrast parameters are explained in Li and Li (2019)
for estimating general causal effects. Default is all pairwise contrasts between any two treatment groups.}

\item{type}{a character specifying the target estimand. The most commonly seen additive estimand is specified
by \code{type = "DIF"}, abbreviated for weighted difference-in-means. This is the usual pairwise average treatment
effects as those defined in Li, Morgan, and Zaslavsky (2018) and Li and Li (2019). For binary (or count outcomes), we also
allow two ratio estimands: causal relative risk (\code{type = "RR"}) and causal odds ratio (\code{type = "OR"}).
Estimates for these two ratio estimands will be reported on the log scale (log relative risk and log
odds ratio) to improve the approximate for asymptotic normality. With binary outcomes, \code{"DIF"} is the same
as the average causal risk difference. Default is "DIF" if left empty.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list of following values:

\describe{
\item{\code{ trtgrp}}{ a character indicating the treatment group, or target population under ATT weights.}

\item{\code{ estimates}}{ a matrix of point estimates, standard errors and 95% confidence intervals
for contrasts of interest.}

\item{\code{ bootestimates}}{ a list of data frames containing estimated contrasts in each bootstrap replicate,
if bootstrap is used to estimate standard errors.}

\item{\code{ contrast}}{ a table listing the specified contrasts of interest.}

\item{\code{ group}}{ a table of treatment group labels corresponding to the output point estimates, provided in results
obtained from \code{\link{PSweight}}.}

}
}
\description{
\code{summary.PSweight} is used to summarize the results from \code{\link{PSweight}}.
The output contains the average causal effects defined by specific contrasts, as well as their
standard error estimates.
}
\details{
For the \code{contrast} argument, one specifies the contrast of interest and thus defines the target estimand
for comparing treatments. For example, if there are three treatment levels: A, B, and C, the contrast A-C
(i.e., E[Y(A)] - E[Y(C)]) can be specified by \code{c(1,0,-1)}. The contrasts of A-C and B-C can be
jointly specified by \code{rbind(c(1,0,-1), c(0,1,-1))}.

For estimating the causal relative risk (\code{type = "RR"}), the contrast is specified at the log scale. For example,
the contrast A-C (specified by \code{c(1,0,-1)}) implies the estimation of log\{E[Y(A)]\} - log\{E[Y(C)]\}. For estimating the causal odds
ratio, the contrast is specified at the log odds scale. For example, the contrast A-C (specified by \code{c(1,0,-1)})
implies the estimation of log\{E[Y(A)]/E[1-Y(A)]\} - log\{E[Y(C)]/E[1-Y(C)]\}.

The variance of the contrasts will be estimated by the delta method (if sandwich variance is used, or
\code{bootstrap = FALSE}), or nonparametric bootstrap (if \code{bootstrap = TRUE}). Details will be given in
Zhou et al. (2020+).

The argument \code{type} takes one of three options: \code{"DIF"}, \code{"RR"}, or \code{"RR"}, with \code{"DIF"} as
the default option. Typically, \code{"RR"} is relavent for binary or count outcomes, and \code{"OR"} is relavent
only for binary outcomes. \code{"DIF"} applies to all types of outcomes.
}
\examples{

## For examples, run: example(PSweight).

}
\references{
Li, F., Morgan, K. L., Zaslavsky, A. M. (2018).
Balancing covariates via propensity score weighting.
Journal of the American Statistical Association, 113(521), 390-400.

Li, F., Li, F. (2019). Propensity score weighting for causal inference with multiple treatments.
The Annals of Applied Statistics, 13(4), 2389-2415.
}
