% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psw_main.R
\name{psw}
\alias{psw}
\title{Propensity score weighting}
\usage{
psw(data, form.ps, weight, std.diff = FALSE, mirror.hist = FALSE,
  add.weight = FALSE, nclass = 50, wt = FALSE, out.var = NULL,
  family = "gaussian", dr = FALSE, form.outcome = NULL, spec.test = F,
  V.name = NULL, trans.type = NULL, K = 4)
}
\arguments{
\item{data}{data frame to be used.}

\item{form.ps}{propensity score model.}

\item{weight}{weighting method to be used. Available methods are \code{"ATE"},  \code{"ATT"}, \code{"ATC"}, \code{"MW"}, \code{"OVERLAP"}, and \code{"TRAPEZOIDAL"}.}

\item{std.diff}{calculate standardized mean difference as a percentage, \code{std.diff=FALSE} by default.}

\item{mirror.hist}{mirror histogram showing the propensity score distributions in both treatment groups, \code{mirror.hist=FALSE} by default.}

\item{add.weight}{add propensity score weights to the mirror histogram, \code{add.weight=FALSE} by default and it is not available for \code{weight="ATE", "ATT"} or \code{"ATC"}.}

\item{nclass}{number of breaks in the mirror histogram.}

\item{wt}{estimate the weighted estimator, \code{wt=FALSE} by default.}

\item{out.var}{outcome variable, needed when \code{wt=TRUE}.}

\item{family}{outcome family, either \code{"gaussian"} or \code{"binomial"}, \code{family="gaussian"} by default.}

\item{dr}{estimate the doubly robust estimator, \code{dr=FALSE} by default.}

\item{form.outcome}{outcome model, needed when \code{dr=TRUE}.}

\item{spec.test}{propensity score model specification test, \code{spec.test=FALSE} by default.
Note that specification test is not available for \code{weight="OVERLAP"}.}

\item{V.name}{a vector of covariates on which the specification test is performed, needed when \code{spec.test=TRUE}.}

\item{trans.type}{a vector of the same length as \code{V.name} that specifies the transformation type for each element in \code{V.name}.
Available transformations are \code{"identity"}, \code{"log"}, \code{"logit"}, \code{"sqrt"}, \code{"Fisher"}.
Needed when \code{spec.test=T}, and no transformation is perfomred with \code{"identity"}. See Details.}

\item{K}{value of \eqn{K} in \eqn{\omega(e_i) = min(1, K min(e_i, 1-e_i)) } for \code{"TRAPEZOIDAL"} weight. The estimand is
closer to the average treatment effect (ATE) with larger value of \code{K}. \code{K=4} by default.}
}
\value{
\code{psw} returns a list of elements depending on the supplied arguments.
\item{weight}{weighting method.}
\item{ps.model}{object returned by fitting the propensity score model using \code{glm} with \code{"binomial"} family.}
\item{ps.hat}{estimated propensity score.}
\item{W}{estimated propensity score weight.}
\item{std.diff.before}{A data frame of weighed mean, variance, and standardized mean difference for covariates in \code{V.name} (see below) by treatment groups before weighting.
\code{V.name} is the row name and \code{"treated.mean"}, \code{"treated.var"}, \code{"control.mean"}, \code{"control.var"}, \code{"std.diff.pct"} are column names.}
\item{std.diff.after}{A data frame of weighed mean, variance, and standardized mean difference for covariates in \code{V.name} by treatment groups after weighting.}
\item{est.wt}{weighted estimator for mean difference when \code{wt=T} and \code{family = "gaussian"}.}
\item{std.wt}{standard error for \code{est.wt}.}
\item{est.dr}{doubly robust estimator for mean difference when \code{dr=T} and \code{family = "gaussian"}.}
\item{std.dr}{standard error for \code{est.dr}.}
\item{est.risk.wt}{weighted estimator for risk difference when \code{wt=T} and \code{family = "binomial"}.}
\item{std.risk.wt}{standard error for \code{est.risk.wt}.}
\item{est.risk.dr}{doubly robust estimator for risk difference when \code{dr=T} and \code{family = "binomial"}.}
\item{std.risk.dr}{standard error for \code{est.risk.dr}.}
\item{est.rr.wt}{weighted estimator for relative risk when \code{wt=T} and \code{family = "binomial"}.}
\item{std.rr.wt}{standard error for \code{est.rr.wt}.}
\item{est.or.wt}{weighted estimator for odds ratio when \code{wt=T} and \code{family = "binomial"}.}
\item{std.or.wt}{standard error for \code{est.or.wt}.}
\item{est.lor.wt}{weighted estimator for log odds ratio when \code{wt=T} and \code{family = "binomial"}.}
\item{std.lor.wt}{standard error for \code{est.lor.wt}.}
\item{V.name}{covariates in the specification test or balance diagnosis.}
\item{g.B1.hat}{a vector of transformed weighted average for covariates in the treated group when \code{spec.test=T}.}
\item{g.B0.hat}{a vector of transformed weighted average for covariates in the control group when \code{spec.test=T}.}
\item{B.hat}{difference between \code{eta.B1.hat} and \code{eta.B0.hat} when \code{spec.test=T}.}
\item{var.B.hat}{covariance matrix for \code{B.hat} when \code{spec.test=T}.}
\item{test.stat}{test statistic for the specification test, which follows the \eqn{\chi^2_{df}} distribution under the null, available when \code{spec.test=T}.}
\item{df}{degree of freedom for the specification test, \code{df=rank(var.B.hat)}, available when \code{spec.test=T}.}
\item{pvalue}{pvalue of the specification test when \code{spec.test=T}.}
}
\description{
\code{psw} is the main function to perfrom propensity score weighting analysis for (1) visualization of the propensity score distribution in both treatment groups,
(2) covariate balance diagnosis, (3) propensity score model specification test, (4) treatment effect estimation and inference, and (5) doubly robust estimation when applicable.
}
\details{
In package \code{PSW}, treatment indicator (left handside of \code{form.ps}) should be dummy coded
such that a value of 1 indicates the treated and a value of 0 indicates the control. All categorical covariates need to be dummy coded too.
If the outcome belongs to the \code{"gaussian"} family, causal estimation is based on the mean differnce between treatment groups. If the
outcome belongs to the \code{"binomial"} family, causal estimation is based on risk difference, risk ratio, odds ratio or log odds ratio.
The Delta method is used for variance estimation when applicable.

Let \eqn{Z_i} be the treatment indicator of subject \eqn{i}, \eqn{e_i} be the corresponding propensity score. Then
propensity score weight, \eqn{W_i}, is defined as \deqn{W_i = \frac{\omega(e_i)}{Z_i e_i + (1-Z_i)(1-e_i)},} where \eqn{\omega(e_i)} is a function depending
on \eqn{e_i}. For \code{"ATE"}, \eqn{\omega(e_i) = 1}, which leads to estimating the average treatment effect. For \code{"ATT"}, \eqn{\omega(e_i) = e_i},
which leads to estimating average treatment effect for the treated. For \code{"ATC"}, \eqn{\omega(e_i) = 1 - e_i}, which leads to estimating average treatment effect
for the controls. For \code{"MW"}, \eqn{\omega(e_i) = min( e_i, 1 - e_i )}. For \code{"OVERLAP"}, \eqn{\omega(e_i) = e_i(1 - e_i)}. For \code{"TRAPEZOIDAL"},
\eqn{\omega(e_i) = min( 1, K min( e_i, 1 - e_i ) )}. This type of weights are studied by Hirano, Imbens and Ridder (2003) and Li et al (2016).
The \eqn{\omega(e_i)} function is specified by the \code{weight} argument.

The matching weight (\code{"MW"}) was proposed by Li and Greene (2013). The overlap weight (\code{"OVERLAP"}) was propsed by Li et al (2016).
These methods down weight subjects with propensity score close to 0 or 1. and hence improve the stability of computation.

A mirror histogram is produced to visualize the propensity score distributions in both treatment groups. In the mirror histogram, above the horizontal line
is the histogram of the propensiy scores of the control group, below is that of the treated group. The vertical axis of the histogram is the frequency. When
\code{mirror.hist.weight=TRUE}, the height of the shaded bar is the summation of the weights of subjects within the corresponding propensity score stratum.
For weighting methods of \code{"ATE"}, \code{"ATT"}, \code{"ATC"}, \code{add.weight} is not recommended for visual display because weights may be larger than 1.

Standardized mean difference for a covariate is defiend as
 \deqn{ \frac{100 (\bar{x}_1 - \bar{x}_0)}{\sqrt{\frac{s_1^2 + s_0^2}{2} } },}
where \eqn{\bar{x}_1} and \eqn{s_1^2} are weighted mean and standard deviation for the treated group, and \eqn{ \bar{x_0}} and \eqn{s_0^2}
are defined similarly for the control group. A plot showing the standardized mean difference before and after weighting adjustement will be generated to
facilitate covariate balance diagnosis. It is sometimes recommended that the absolute values of standardized mean differences of all covariates should be less
than \code{10\%} in order to claim covariate balance.

For the proensity score model specification test (Li and Greene, 2013), the quantity of interest is
\deqn{ \hat{B} = \boldsymbol{g} \left\{ \frac{ \sum_{i=1}^n W_i Z_i \boldsymbol{V}_i}{\sum_{i=1}^n W_i Z_i}\right\} - \boldsymbol{g} \left\{ \frac{ \sum_{i=1}^n W_i (1-Z_i) \boldsymbol{V}_i}{\sum_{i=1}^n W_i (1-Z_i)}\right\}, }
where \eqn{\boldsymbol{V}_i} is a vector of covariates whose balance are examined, and \eqn{\boldsymbol{g}(.)} is a vector of monotone smooth transformations for the input.
Transformation type is specified by argument \code{trans.type}, and available transformation types are \code{"identity"}, \code{"log"}, \code{"logit"}, \code{"sqrt"}, \code{"Fisher"}.
These transformations are recommended to improve the finite sample performance of the specification test. Log transformation (\code{"log"}) and square root transformation (\code{"sqrt"})
are recommended for skewed data, Logit transformation (\code{"logit"}) for binary data, and Fisher z-transformation (\code{"Fisher"}) for bounded data between \eqn{(-1, 1)}.
The current version of model specification test is not available for \code{weight="OVERLAP"} because it results in zero standardized difference.

For estimation of mean difference (\code{"gaussian"} family) or risk difference (\code{"binomial"} family), the weighted estimator is
\deqn{ \hat{\Delta} = \frac{\sum_{i=1}^n W_i Z_i Y_i}{\sum_{i=1}^n W_i Z_i} - \frac{\sum_{i=1}^n W_i (1-Z_i) Y_i}{\sum_{i=1}^n W_i (1-Z_i)}, }
and the doubly robust estimator is
\deqn{\hat{\Delta}_{DR} = \frac{ \sum_{i=1}^n \omega(e_i) \{ m_{1i} - m_{0i} \}}{ \sum_{i=1}^n \omega(e_i) } + \frac{ \sum_{i=1}^n W_i Z_i \{ Y_i - m_{1i} \}}{ \sum_{i=1}^n W_i Z_i } - \frac{ \sum_{i=1}^n W_i (1-Z_i) \{ Y_i - m_{0i} \}}{ \sum_{i=1}^n W_i (1-Z_i)},}
where \eqn{m_{1i} = E[Y_i | \boldsymbol{X_i}, Z_i=1]} is the conditional expectation of outcome when treated given covariates \eqn{\boldsymbol{X}_i},
and \eqn{m_{0i} = E[Y_i | \boldsymbol{X_i}, Z_i=0]} is the conditional expectation of outcome when control given covariates \eqn{\boldsymbol{X}_i}.
When the outcome belongs to the \code{"binomial"} family, the marginal probability is used to estimate risk ratio, odds ratio and log odds ratio.
Sandwich variance estimation is used to adjust for the uncertainty in the estimated propensity score (Li and Greene, 2013).
}
\examples{
# Load the test data set
data(test_data);

# Propensity score model
form.ps <- "Z ~ X1 + X2 + X3 + X4";

#1. Standardized differnce with "ATE"
tmp1 <- psw( data = test_data, form.ps = form.ps, weight = "ATE" );

#2. Mirror histogram and add weights to it with "MW".
tmp2 <- psw( data = test_data, form.ps = form.ps, weight = "MW",
add.weight = T );

#3. Estimate average treatment effect with "ATE"
tmp3 <- psw( data = test_data, form.ps = form.ps, weight = "ATE", wt = TRUE,
out.var = "Y", family = "gaussian" );

#4. Doubly robust estimator with "OVERLAP"
# outcome model
form.out <- "Y ~ X1 + X2 + X3 + X4";
tmp4 <- psw( data = test_data, form.ps = form.ps, weight = "OVERLAP", dr = TRUE,
form.outcome = form.out, family = "gaussian" );

#5. Propensity score model specification test with "MW".
# A vector of covariates
V.name <- c( "X1", "X2", "X3", "X4" );
# A vector of transformation types for covariates in V.name.
trans.type <- c( "identity", "identity", "logit", "logit" );
tmp5 <- psw( data = test_data, form.ps = form.ps, weight = "MW", spec.test = TRUE,
V.name = V.name, trans.type = trans.type );

}
\references{
Hirano K, Imbens GW and Ridder G. "Efficient estimation of average treatment effects using the estimated propensity score." Econometrica 2003; 71(4): 1161-1189.

Li F, Morgan KL and Zaslavsky AM. "Balancing covariates via propensity score weighting." J Am Stat Assoc 2016; DOI:10.1080/01621459.2016.1260466.

Li L and Greene T. "A weighting analogue to pair matching in propensity score analysis." Int J Biostat 2013; 9(2):215-234.
}
\seealso{
\link{psw.balance}, \link{psw.spec.test}, \link{psw.wt}, \link{psw.dr}, \link{psw.mirror.hist}.
}
