\name{pdist}
\docType{methods}
\alias{pdist}
\alias{pdist,PSTf,PSTf-method}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
	Compute probabilistic divergence between two PST
}
%
\description{
Compute probabilistic divergence between two PST
}
\usage{
\S4method{pdist}{PSTf,PSTf}(x,y, method="cp", l, ns=5000, symetric=FALSE, output="all")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
	A PST, that is an object of class \code{PSTf} as returned by the \code{\link{pstree}} or \code{\link{prune}} method.
}
  \item{y}{
	A PST, that is an object of class \code{PSTf} as returned by the \code{\link{pstree}} or \code{\link{prune}} method.
} 
  \item{method}{
	character. Method for computing distances. So far only one method is available.
}
 \item{l}{
	integer. Length of the sequence(s) to generate.
}
  \item{ns}{
	integer. Number sequences to generate.
}
  \item{symetric}{
	logical. If \code{TRUE}, the symetric version of the measure is returned, see details.
}
  \item{output}{
	character. See \code{value}.
}
}

\details{
The function computes a probabilistic divergence measure between PST \eqn{S_{A}} and \eqn{S_{B}} based on the measure originally proposed in \cite{Juang-1985} and \cite{Rabiner-1989} for the comparison of two (hidden) Markov models \eqn{S_{A}} and \eqn{S_{B}}
\deqn{
d(S_{A}, S_{B})=\frac{1}{\ell} [\log P^{S_{A}}(x)-\log P^{S_{B}}(x)]=\frac{1}{\ell}\log \frac{P^{S_{A}}(x)}{P^{S_{B}}(x)}
}
where \eqn{x=x_{1}, \ldots, x_{\ell}} is a sequence generated by model \eqn{S_{A}}, \eqn{P^{S_{A}}(x)} is the probability of $x$ given model \eqn{S_{A}} and \eqn{P^{S_{B}}(x)} is the probability of \eqn{x} given model \eqn{S_{B}}. The ratio between the two sequence likelihoods measures how many times the sequence \eqn{x} is more likely to have been generated by \eqn{S_{A}} than by \eqn{S_{2}}. 

As the number $n$ of generated sequences on which the measure is computed (or the length of a single sequence) approaches infinity, the expected value of \eqn{d(S_{A}, S_{B})} converges to \eqn{d_{KL}(S_{A}, S_{B})} \cite{Falkhausen-1995, He-2000}, the Kullback-Leibler (KL) divergence (also called information gain) used in information theory to measure the difference between two probability distributions.

The \code{pdist} function uses the following procedure to compute the divergence between two PST:
\itemize{
\item generate a ransom sample of \eqn{n} sequences (of length \eqn{\ell}) with model \eqn{S_{A}} using the \code{\link{generate}} method
\item predict the sequences with \eqn{S_{A}} and with \eqn{S_{B}}
\item compute 
\deqn{
d_{i}(S_{A}, S_{B})=\frac{1}{\ell} [\log P^{S_{A}}(x_{i})-\log P^{S_{B}}(x_{i}))], \; i=1, \ldots, n
}
\item the expected value 
\deqn{
E(d(S_{A}, S_{B}))
}
is the divergence between models \eqn{S_{A}} and \eqn{S_{B}} and is estimated as 
\deqn{
\hat{E}(d(S_{A}, S_{B}))=\frac{1}{n} \sum_{i=1}^{n} d_{i}(S_{A}, S_{B})
}
}

}
\value{
If \code{ouput="all"}, a vector containing the divergence value for each generated sequence, if \code{output="mean"}, the mean, i.e. expected value which is the divergence between models.
}
\references{
Juang, B. H. and Rabiner, L. R. (1985). A probabilistic distance measure for hidden Markov models. \emph{ATT Technical Journal} \bold{64}(2), 391-408.

Rabiner, L. R. (1989). A tutorial on hidden Markov models and selected applications in speech recognition. \emph{Proceedings of the IEEE} \bold{77}(2), 257-286.
}
\author{
Alexis gabadinho
}

\examples{
## activity calendar for year 2000
## from the Swiss Household Panel
## see ?actcal
data(actcal)

## selecting individuals aged 20 to 59
actcal <- actcal[actcal$age00>=20 & actcal$age00 <60,]

## defining a sequence object
actcal.lab <- c("> 37 hours", "19-36 hours", "1-18 hours", "no work")
actcal.seq <- seqdef(actcal,13:24,labels=actcal.lab)

## building a PST segmented by age group
gage10 <- cut(actcal$age00, c(20,30,40,50,60), right=FALSE,
	labels=c("20-29","30-39", "40-49", "50-59"))

actcal.pstg <- pstree(actcal.seq, nmin=2, ymin=0.001, group=gage10)

## pruning
C99 <- qchisq(0.99,4-1)/2
actcal.pstg.opt <- prune(actcal.pstg, gain="G2", C=C99)

## extracting PST for age group 20-39 and 30-39
g1.pst <- subtree(actcal.pstg.opt, group=1)
g2.pst <- subtree(actcal.pstg.opt, group=2)

## generating 5000 sequences with g1.pst 
## and computing 5000 distances
dist.g1_g2 <- pdist(g1.pst, g2.pst, l=11)
hist(dist.g1_g2)

## the probabilistic distance is the mean
## of the 5000 distances
mean(dist.g1_g2)
}

\keyword{models}

