% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csbread.R
\name{csbread}
\alias{csbread}
\title{Reads the state of a structured population model from a CSB file}
\usage{
csbread(csbfile = NULL, state = -1)
}
\arguments{
\item{csbfile}{(string, required)
\preformatted{}
              Name of the CSB file to be read with or without '.csb' extension.}

\item{state}{(integer, optional)
\preformatted{}
              If not specified \code{csbread} will list the states that are
              stored in the CSB file. If specified, it should be the name or index
              of one of the states in the CSB file.}
}
\value{
If a specific state is specified and found in the file, the state is
returned as a list.
}
\description{
\code{csbread} reads a CSB file, which is generated by \code{\link{PSPMdemo}},
\code{\link{PSPMequi}}, \code{\link{PSPMecodyn}} and \code{\link{PSPMevodyn}}
to save the entire state of the environmental variables and physiologically
structured populations during computations.
}
\details{
output <- csbread(csbfile = NULL, state = -1)
}
\examples{
\dontrun{
PSPMdemo("Medfly", c(2, 11, 0.1, 11, 15), clean = TRUE)
csbread("Medfly-PGR-0000")

csbread("Medfly-PGR-0000", 1)
}

}
