% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psf_plot.R
\name{plot.psf}
\alias{plot.psf}
\title{Plot actual and forecasted values of an univariate time series}
\usage{
\method{plot}{psf}(x, predictions = c(), cycle = 24, ...)
}
\arguments{
\item{x}{The trained PSF model generated by psf() function.}

\item{predictions}{A vector with previously computed forecasted values.}

\item{cycle}{The number of values that conform a cycle in the time series (e.g. 24 hours per day, 12 month per year, and so on). Only used when input data is not in time series (ts) format.}

\item{\dots}{Additional graphical parameters given to plot function.}
}
\description{
Takes an univariate time series and a vector with forecasted values.
}
\examples{
## Train a PSF model from the univariate time series 'nottem' (package:datasets).
p <- psf(nottem)

## Forecast the next 12 values of such time series.
pred <- predict(p, n.ahead = 12)

## Plot forecasted values.
plot(p, pred)
}
