% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linking_functions.R
\name{runRSSS}
\alias{runRSSS}
\title{Run Crosswalk Table Generation}
\usage{
runRSSS(
  data,
  ipar_linked,
  prior_mean = 0,
  prior_sd = 1,
  min_theta = -4,
  max_theta = 4,
  inc = 0.01,
  min_score = 1
)
}
\arguments{
\item{data}{a \code{\linkS4class{PROsetta_data}} object. See \code{\link{loadData}} for loading a dataset.}

\item{ipar_linked}{an object returned from \code{\link{runLinking}} or \code{\link{runCalibration}}.}

\item{prior_mean}{prior mean.}

\item{prior_sd}{prior standard deviation.}

\item{min_theta}{the lower limit of theta grid.}

\item{max_theta}{the upper limit of theta grid.}

\item{inc}{the increment to use in theta grid.}

\item{min_score}{minimum item score (0 or 1).}
}
\value{
\code{\link{runRSSS}} returns a \code{\link{list}} containing crosswalk tables.
}
\description{
\code{\link{runRSSS}} is a function to generate raw-score to standard-score crosswalk tables from supplied calibrated item parameters.
}
\examples{
\donttest{
out_link    <- runLinking(data_asq, method = "FIXEDPAR")
score_table <- runRSSS(data_asq, out_link)
}

}
