% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_freq.R
\name{gen_freq}
\alias{gen_freq}
\title{generating the start values for PROSPER models}
\usage{
gen_freq(af, n_seeds, result = "initialSB", max_vec_length = 1e+07)
}
\arguments{
\item{af}{initial frequency of resistance alleles in the population. \code{numeric vector} with length of \code{ng} (number of genes) and elements in [0,1].}

\item{n_seeds}{initial number of weed seeds. They will be allocated to the genotypes. \code{integer}.}

\item{result}{name of the results column. \code{character}.}

\item{max_vec_length}{used internally, a technical term, defining the maximum length of vectors to be used.}
}
\value{
Returns a \code{data.frame} containing the genotypes and their frequencies provided by \code{dfgenotype}.
}
\description{
\code{gen_freq} generates the numbers of genotypes at the beginning of the first simulated year.
}
\details{
The start values for a model include the initial frequencies of alleles and the initial seedbank, i.e. the number of seeds in the soil. \code{gen_freq} allocates the \code{n_seeds} individuals to the different genotypes as provided by \code{dfgenotype}, which is created by \code{struc_preparation()}.
}
\examples{
# generate a 'dfgenotype' data.frame:
struc_preparation(Rmx=10, n_loci=2, epis=0, dom=1)
#Distribute 10000 individuals of the starting population across the genotypes. 
#The two gene loci have initial frequencies of 0.01 and 0.8.
gen_freq(af=c(0.01,0.8), n_seeds=10000)
rm(dfgenotype, mf, xprobab)
}
\seealso{
\code{\link{sel_resist}} \code{\link{struc_preparation}}
}
