% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_bias_adjustment.R
\name{cluster_bias_adjustment}
\alias{cluster_bias_adjustment}
\title{Cluster Bias Correction}
\usage{
cluster_bias_adjustment(sigma2js, cluster_size = 22, icc = 0.2)
}
\arguments{
\item{sigma2js}{A vector of sampling variance estimates that do not account for clustering.}

\item{cluster_size}{A numerical value for average cluster size.}

\item{icc}{Assumed intra-class correlation (proportion of total variance at the cluster level).}
}
\value{
Returns a vector of cluster bias adjusted variance estimates
}
\description{
Function to conduct cluster bias correction of sampling variance estimates
obtained from cluster-randomized studies in which the reported variance does not account for clustering.
}
\examples{
cbc_var <- cluster_bias_adjustment(
  sigma2js = c(0.04, 0.06, 0.08, 0.1),
  cluster_size = 15,
  icc = 0.15
)

cbc_var


}
