% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mandelhTest.R
\name{mandelhTest}
\alias{mandelhTest}
\alias{mandelhTest.default}
\alias{mandelhTest.formula}
\title{Mandel's h Test According to E 691 ASTM}
\usage{
mandelhTest(x, ...)

\method{mandelhTest}{default}(x, g, ...)

\method{mandelhTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"mandel"} containing the following components:
\describe{
\item{method}{a character string
indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{p.value}{the p-value for the test.}
\item{statistic}{the estimated quantiles of Mandel's statistic.}
\item{alternative}{a character string describing
the alternative hypothesis.}
\item{grouplev}{a character vector describing the
levels of the groups.}
\item{nrofrepl}{the number of replicates for each group.}
}
}
\description{
The function calculates the
consistency statistics h and corresponding
p-values for each group (lab) according to
Practice E 691 ASTM.
}
\examples{
data(Pentosan)
mandelhTest(value ~ lab, data=Pentosan, subset=(material == "A"))
}
\references{
Practice E 691 (2005) \emph{Standard Practice for
Conducting an Interlaboratory Study to Determine the
Precision of a Test Method}, ASTM International.
}
\seealso{
\code{\link{qmandelh}} \code{\link{pmandelh}}
}
\keyword{htest}
