% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.PMCMR.R
\name{barPlot}
\alias{barPlot}
\title{Plotting PMCMR Objects}
\usage{
barPlot(x, alpha = 0.05, ...)
}
\arguments{
\item{x}{an object of class \code{"PMCMR"}.}

\item{alpha}{the selected alpha-level. Defaults to 0.05.}

\item{\dots}{further arguments for method \code{barplot}.}
}
\value{
A barplot where the height of the bars corresponds to the arithmetic
mean. The extend of the whiskers are \eqn{\pm z_{(1-\alpha/2)}
\times s_{\mathrm{E},i}}, where the latter denotes the standard error
of the \eqn{i}th group. Symbolic letters are depicted on top of the bars,
whereas different letters indicate significant differences between
groups for the selected level of alpha.
}
\description{
Plots a bar-plot for objects of class \code{"PMCMR"}.
}
\note{
The barplot is strictly spoken only valid for normal data, as
the depicted significance intervall implies symetry.
}
\examples{
## data set chickwts
ans <- tukeyTest(weight ~ feed, data = chickwts)
barPlot(ans)
}
\keyword{plot}
