% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_Entrez_ID.R
\name{get_Entrez_ID}
\alias{get_Entrez_ID}
\title{Convert gene symbol to Entrez_Gene_ID}
\usage{
get_Entrez_ID(mut_status, gene_symbol_Entrez, Entrez_ID = TRUE)
}
\arguments{
\item{mut_status}{A binary matrix that contains the mutation state of genes in each sample and its row name is the gene symbol. Noted the matrix can be generated by the function `get_mut_status`.}

\item{gene_symbol_Entrez}{A data table containing gene symbol and the corresponding gene Entrez ID.}

\item{Entrez_ID}{Logical,tell whether there are Entrez IDs corresponding to gene symbol in the gene_symbol_Entrez.}
}
\value{
A binary matrix that contains the mutation state of genes in each sample and its row name is Entrez_Gene_ID.
}
\description{
The function `get_Entrez_ID` is used to convert gene symbol to Entrez_Gene_ID
}
\examples{
#load the data.
data(mut_status,gene_symbol_Entrez)
#perform function `get_Entrez_ID`.
mut_status<-get_Entrez_ID(mut_status,gene_symbol_Entrez,Entrez_ID=TRUE)
}
