% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_breast_data.R
\name{download_breast_data}
\alias{download_breast_data}
\title{Download and return the breast data}
\usage{
download_breast_data(url = "https://tibshirani.su.domains/PMA/breastdata.rda")
}
\arguments{
\item{url}{source, default \code{"https://tibshirani.su.domains/PMA/breastdata.rda"}}
}
\value{
a list containing the following elements:
\itemize{
\item \code{dna}: a 2149x89 matrix of CGH spots x Samples
\item \code{rna}: a 19672x89 matrix of Genes x Samples
\item \code{chrom}: a 2149-vector of chromosomal location of each CGH spot
\item \code{nuc}: a 2149-vector of nucleotide position for each CGH spot
\item \code{gene}: a 19672-vector wiith an accession number for each gene
\item \code{genenames}: a 19672-vector with a name for each gene
\item \code{genechr}: a 19672-vector with a chromosomal location for each gene
\item \code{genedesc}: a 19672-vector with a description for each gene
\item \code{genepos}: a 19672-vector with a nucleotide position for each gene.
}
}
\description{
Breast cancer gene expression + DNA copy number data set from Chin
et. al. and used in Witten, et. al. See references below.

This data set consists of gene expression and DNA copy number
measurements on a set of 89 samples. The data set can be used to
perform integrative analysis of gene expression and DNA copy number
data, as in . That is,
we can look for sets of genes that are associated with regions of
chromosomal gain/loss.

Missing values were imputed using 5-nearest neighbors (see library
\code{pamr}).
}
\references{
Chin K., et. al. (2006) \doi{10.1016/j.ccr.2006.10.009}.

Witten D. M., Tibshirani R.,  and Hastie, T. (2009) \doi{10.1093/biostatistics/kxp008}.
}
