% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsim.est.r
\name{plsim.est}
\alias{plsim.est}
\alias{plsim.est.formula}
\alias{plsim.est.default}
\title{Profile Least Squares Estimator}
\usage{
plsim.est(\dots)

\method{plsim.est}{formula}(formula, data, \dots)

\method{plsim.est}{default}(xdat=NULL, zdat, ydat, h=NULL, zetaini=NULL, MaxStep = 200L,
ParmaSelMethod="SimpleValidation", TestRatio=0.1, K = 3, seed=0, verbose=TRUE, \dots)
}
\arguments{
\item{\dots}{additional arguments.}

\item{formula}{a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment containing the variables in the model.}

\item{xdat}{input matrix (linear covariates). The model reduces to a single index model when \code{x} is NULL.}

\item{zdat}{input matrix (nonlinear covariates). \code{z} should not be NULL.}

\item{ydat}{input vector (response variable).}

\item{h}{a value or a vector for bandwidth. If \code{h} is NULL, a default vector c(0.01,0.02,0.05,0.1,0.5)
will be set for it. \link{plsim.bw} is employed to select the optimal bandwidth when h is a vector or NULL.}

\item{zetaini}{initial coefficients, optional (default: NULL). It could be obtained by the function \code{\link{plsim.ini}}.
\code{zetaini[1:ncol(z)]} is the initial coefficient vector \eqn{\boldmath{\alpha}_0},
and \code{zetaini[(ncol(z)+1):(ncol(z)+ncol(x))]} is the initial coefficient vector \eqn{\boldmath{\beta}_0}.}

\item{MaxStep}{the maximum iterations, optional (default=200).}

\item{ParmaSelMethod}{the parameter for the function \link{plsim.bw}.}

\item{TestRatio}{the parameter for the function \link{plsim.bw}.}

\item{K}{the parameter for the function \link{plsim.bw}.}

\item{seed}{int, default: 0.}

\item{verbose}{bool, default: TRUE. Enable verbose output.}
}
\value{
\item{eta}{estimated non-parametric part \eqn{\hat{\eta}(Z^T\boldmath{\hat{\alpha} })}.}
\item{zeta}{estimated coefficients. \code{zeta[1:ncol(z)]} is \eqn{\hat{\alpha}}, 
and \code{zeta[(ncol(z)+1):(ncol(z)+ncol(x))]} is \eqn{\hat{\beta}}.}
\item{y_hat}{ \code{y}'s estimates.}
\item{mse}{mean squared errors between y and \code{y_hat}.}
\item{data}{data information including \code{x}, \code{z}, \code{y}, bandwidth \code{h}, 
initial coefficients \code{zetaini}, iteration step \code{MaxStep} and flag \code{SiMflag}. 
\code{SiMflag} is TRUE when \code{x} is NULL, otherwise \code{SiMflag} is FALSE.}
\item{Z_alpha}{\eqn{Z^T\boldmath{\hat{\alpha}}}.}
\item{r_square}{multiple correlation coefficient.}
\item{variance}{variance of \code{y_hat}.}
\item{stdzeta}{standard error of \code{zeta}.}
}
\description{
PLS was proposed by Liang \emph{et al.} (2010) 
to estimate parameters in PLSiM
\deqn{Y = \eta(Z^T\alpha) + X^T\beta + \epsilon.}
}
\examples{

# EXAMPLE 1 (INTERFACE=FORMULA)
# To estimate parameters of partially linear single-index model (PLSiM). 

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")

beta = matrix(4,1,1)

# Case 1: Matrix Input
x = matrix(1,n,1)
z = matrix(runif(n*2),n,2)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

fit = plsim.est(y~x|z)
summary(fit)

# Case 2: Vector Input
x = rep(1,n)
z1 = runif(n)
z2 = runif(n) 
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

fit = plsim.est(y~x|z1+z2)
summary(fit)

# EXAMPLE 2 (INTERFACE=DATA FRAME) 
# To estimate parameters of partially linear single-index model (PLSiM).  

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")

beta = matrix(4,1,1)

x = rep(1,n)
z1 = runif(n)
z2 = runif(n) 
X = data.frame(x)
Z = data.frame(z1,z2)

x = data.matrix(X)
z = data.matrix(Z)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

fit = plsim.est(xdat=X,zdat=Z,ydat=y)
summary(fit)

}
\references{
H. Liang, X. Liu, R. Li, C. L. Tsai. \emph{Estimation and testing for partially linear single-index models}.
Annals of statistics, 2010, 38(6): 3811.
}
