% Generated by roxygen2 (4.0.1): do not edit by hand
\name{SPLS.binomial.GLM}
\alias{SPLS.binomial.GLM}
\title{Sparse Partial Least Squares-Generalized Linear Model (SPLS-GLM) algorithm for Binomial y}
\usage{
SPLS.binomial.GLM(X, y, A, lambdaY, lambdaX, eps = 0.001, ...)
}
\arguments{
\item{X}{A (NxP) predictor matrix}

\item{y}{A (Nx1) Binomial-distributed response vector}

\item{A}{The number of PLS components}

\item{lambdaY}{A value for the penalty parameters for the soft-thresholding penalization function for Y-weights}

\item{lambdaX}{A value for the penalty parameters for the soft-thresholding penalization function for X-weights}

\item{eps}{Cut off value for convergence step}

\item{...}{Other arguments. Currently ignored}
}
\value{
The SPLS-GLM parameters of D=[X y]
}
\description{
Takes in a set of predictor variables and a set of response variables and gives the SPLS-GLM parameters.
}
\examples{
if(require(MASS))
data(Pima.tr, package="MASS")
X = as.matrix(cbind(Pima.tr[,1:7]))
dimnames(X) = list(1:nrow(X), colnames(X))
y = as.matrix(as.numeric(Pima.tr$type)-1, ncol=1)
#0=No and 1=Yes
dimnames(y) = list(1:nrow(y), paste("type"))
SPLS.binomial.GLM(scale(X), scale(y), A=2, lambdaY=0, lambdaX=0.96, eps=1e-3)
#lambdaX and lambdaY value are determined using function opt.penalty.values
#for more details, see opt.penalty.values help file
}
\author{
Opeoluwa F. Oyedele and Sugnet Gardner-Lubbe
}

