% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNfit-S3methods.R
\name{vcov.PLNfit}
\alias{vcov.PLNfit}
\title{Calculate Variance-Covariance Matrix for a fitted \code{\link[=PLN]{PLN()}} model object}
\usage{
\method{vcov}{PLNfit}(object, type = c("main", "covariance"), ...)
}
\arguments{
\item{object}{an R6 object with class \code{\link{PLNfit}}}

\item{type}{type of parameter that should be extracted. Either "main" (default) for \deqn{B} or "covariance" for \deqn{\Sigma}}

\item{...}{additional parameters for S3 compatibility. Not used}
}
\value{
A matrix of variance/covariance extracted from the PLNfit model. If type="main" and \eqn{B} is a matrix of size d * p, the result is a block-diagonal matrix with p (number of species) blocks of size d (number of covariates). if type="main", it is a symmetric matrix of size p.
.
}
\description{
Returns the variance-covariance matrix of the main parameters of a fitted \code{\link[=PLN]{PLN()}} model object. The main parameters of the model correspond to \deqn{B}, as returned by \code{\link[=coef.PLNfit]{coef.PLNfit()}}. The function can also be used to return the variance-covariance matrix of the residuals. The latter matrix can also be accessed via \code{\link[=sigma.PLNfit]{sigma.PLNfit()}}
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLN(Abundance ~ 1 + offset(log(Offset)), data = trichoptera)
vcov(myPLN) ## variance-covariance of B
vcov(myPLN, type = "covariance") ## Sigma
}
\seealso{
\code{\link[=sigma.PLNfit]{sigma.PLNfit()}}, \code{\link[=coef.PLNfit]{coef.PLNfit()}}, \code{\link[=standard_error.PLNfit]{standard_error.PLNfit()}}
}
